/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.util.DuplicateValueEliminator;

public abstract class DistinctSetFunctionState
implements ISetFunctionState {
    private boolean distinct;
    protected DuplicateValueEliminator dupe;

    public DistinctSetFunctionState() {
    }

    public DistinctSetFunctionState(XDataContext context, IDataType type, boolean isDistinct) {
        this.distinct = isDistinct;
    }

    @Override
    public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
        IValue input = pEvaluator.getParameter(context, 0);
        if (!this.distinct) {
            this.iterateImpl(context, input);
            return;
        }
        if (this.dupe == null) {
            this.dupe = new DuplicateValueEliminator(context);
        }
        this.dupe.write(input);
    }

    protected abstract void iterateImpl(XDataContext var1, IValue var2);

    @Override
    public void getResult(XDataContext context, IValue value) {
        if (!this.distinct) {
            this.getResultImpl(context, value);
            return;
        }
        if (this.dupe != null) {
            IValue input;
            while ((input = this.dupe.next()) != null) {
                this.iterateImpl(context, input);
            }
            this.dupe.release();
            this.dupe = null;
        }
        this.getResultImpl(context, value);
    }

    protected abstract void getResultImpl(XDataContext var1, IValue var2);

    @Override
    public void terminate(XDataContext context) {
        if (this.dupe != null) {
            this.dupe.release();
            this.dupe = null;
        }
    }
}

