/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function;

import com.cognos.xqe.ast.sql.ddl.SQLCreateFunction;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.BigDecimalValue;
import com.cognos.xqe.data.values.BinaryValue;
import com.cognos.xqe.data.values.BlobValue;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.CharValue;
import com.cognos.xqe.data.values.ClobValue;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.FloatValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.JSONValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.data.values.NCharValue;
import com.cognos.xqe.data.values.NVarcharValue;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.data.values.PeriodValue;
import com.cognos.xqe.data.values.SmallintValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimeWithTZValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.VarBinaryValue;
import com.cognos.xqe.data.values.VarcharValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.Cursor;
import com.cognos.xqe.function.Empty;
import com.cognos.xqe.function.ErrorList;
import com.cognos.xqe.function.Function;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.function.IFunctionState;
import com.cognos.xqe.function.character.CharacterFunctions;
import com.cognos.xqe.function.collection.CollectionFunctions;
import com.cognos.xqe.function.conditional.ConditionalFunctions;
import com.cognos.xqe.function.convert.ConvertFunctions;
import com.cognos.xqe.function.date.DateFunctions;
import com.cognos.xqe.function.json.JSONFunctions;
import com.cognos.xqe.function.numeric.NumericFunctions;
import com.cognos.xqe.function.operator.OperatorFunctions;
import com.cognos.xqe.function.regex.RegexFunctions;
import com.cognos.xqe.function.set.SetFunctions;
import com.cognos.xqe.function.set.regression.RegressionFunctions;
import com.cognos.xqe.function.udf.IUDFunction;
import com.cognos.xqe.function.udf.UDJavaAggregateFunction;
import com.cognos.xqe.function.udf.UDJavaScalarFunction;
import com.cognos.xqe.function.udf.UDJavaTableFunction;
import com.cognos.xqe.function.udf.UDProcedure;
import com.cognos.xqe.function.udf.UDSQLAggregateFunction;
import com.cognos.xqe.function.udf.UDSQLScalarFunction;
import com.cognos.xqe.function.udf.UDSQLTableFunction;
import com.cognos.xqe.function.udf.UDScriptAggregateFunction;
import com.cognos.xqe.function.udf.UDScriptScalarFunction;
import com.cognos.xqe.function.udf.UDScriptTableFunction;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ArrayUtil;
import com.cognos.xqe.util.CollectionCast;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;

public final class FunctionManager {
    private static final String PROP_SCAN_FOR_USER_DEFINED_FUNCTIONS = "general.scanForUserDefinedFunctions[@enabled]";
    private static final String COLON = ":";
    private static final String EXCLAMATION_POINT = "!";
    private static final String THISJAR = "thisjar";
    private static final String SQL = "SQL";
    private static final String JAVA = "JAVA";
    private static final String S_S = "%s.%s";
    private static Hashtable<String, IFunction> bifShareableDirectory = new Hashtable();
    private static Hashtable<String, Class<?>> bifNonShareableDirectory = new Hashtable();
    private static Hashtable<String, List<IUDFunction>> udfDirectory = new Hashtable();
    private static Map<Class<?>, Object> classMap = new HashMap();
    private static Map<Byte, Class<?>[]> typeMap;
    private static Map<DataSubType, Class<?>[]> subTypeMap;
    private static List<String> languages;
    private static XQELogger infoLogger;
    private static XQELogger errorLogger;
    private static FunctionManager instance;
    private static List<Class<?>[]> bifClasses;

    private FunctionManager() {
        bifClasses = new ArrayList<Class<?>[]>();
        bifClasses.add(CharacterFunctions.CLASSES);
        bifClasses.add(CollectionFunctions.CLASSES);
        bifClasses.add(ConditionalFunctions.CLASSES);
        bifClasses.add(ConvertFunctions.CLASSES);
        bifClasses.add(DateFunctions.CLASSES);
        bifClasses.add(NumericFunctions.CLASSES);
        bifClasses.add(OperatorFunctions.CLASSES);
        bifClasses.add(SetFunctions.CLASSES);
        bifClasses.add(RegexFunctions.CLASSES);
        bifClasses.add(RegressionFunctions.CLASSES);
        bifClasses.add(JSONFunctions.CLASSES);
        try {
            bifClasses.add(new Class[]{Cursor.class});
            bifClasses.add(new Class[]{Empty.class});
        }
        catch (NoClassDefFoundError e) {
            errorLogger.log(e);
        }
        try {
            Class<?> clazz = Class.forName("com.cognos.xqe.function.xml.XmlFunctions");
            try {
                Field field = clazz.getField("CLASSES");
                try {
                    Class[] classes = (Class[])field.get(null);
                    bifClasses.add(classes);
                }
                catch (IllegalAccessException e) {
                    throw new XQERuntimeException(e);
                }
            }
            catch (NoSuchFieldException e) {
                throw new XQERuntimeException(e);
            }
        }
        catch (ClassNotFoundException e) {
            infoLogger.log("Optional XML feature pack not found (ClassNotFoundException).");
        }
        catch (NoClassDefFoundError e) {
            infoLogger.log("Optional XML feature pack not found (NoClassDefFoundError).");
        }
        languages.add(SQL);
        languages.add(JAVA);
        ScriptEngineManager seMgr = new ScriptEngineManager();
        List<ScriptEngineFactory> seFactories = seMgr.getEngineFactories();
        for (ScriptEngineFactory factory : seFactories) {
            String language = factory.getLanguageName();
            if (language.equals("ECMAScript")) {
                languages.add("JAVASCRIPT");
                continue;
            }
            languages.add(language.toUpperCase());
        }
        try {
            this.loadUserDefinedFunctions();
        }
        catch (Exception e) {
            errorLogger.log(e);
        }
    }

    public static FunctionManager getInstance() {
        return instance;
    }

    private void loadUserDefinedFunctions() {
        FilenameFilter filter;
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (!configuration.getBooleanProperty(PROP_SCAN_FOR_USER_DEFINED_FUNCTIONS, true)) {
            return;
        }
        String extLibPath = configuration.getExtLibDirectory();
        File extDir = new File(extLibPath);
        String[] fileList = extDir.list(filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (fileList == null) {
            return;
        }
        for (String fileName : fileList) {
            ArrayList<String> errors = this.processJarFile(extLibPath + File.separator + fileName);
            for (String error : errors) {
                errorLogger.log(error);
            }
            errors.clear();
        }
    }

    public ArrayList<String> processJarFile(String jarName) {
        ErrorList errors = new ErrorList();
        List<SQLCreateFunction> fList = null;
        try {
            File file = new File(jarName);
            JarFile jFile = new JarFile(file);
            StringTokenizer tokenizer = new StringTokenizer(jFile.getName(), File.separator);
            String unqJarName = null;
            while (tokenizer.hasMoreTokens()) {
                unqJarName = tokenizer.nextToken();
            }
            Manifest manifest = jFile.getManifest();
            Set<Map.Entry<String, Attributes>> s = manifest.getEntries().entrySet();
            for (Map.Entry<String, Attributes> element : s) {
                Attributes attributes = element.getValue();
                String attributeValue = attributes.getValue("SQLJDeploymentDescriptor");
                if (attributeValue == null || !attributeValue.equalsIgnoreCase("TRUE")) continue;
                String ddlName = element.getKey();
                ZipEntry jEntry = jFile.getEntry(ddlName);
                if (jEntry == null) {
                    errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_DDLFileNotFound, XQEMessages.getCurrProductLocale(), ddlName));
                    continue;
                }
                InputStream is = jFile.getInputStream(jEntry);
                try {
                    fList = SQLProcessor.parseDeploymentDescriptor(is);
                }
                catch (ParseException e) {
                    errors.add(e.getLocalizedMessage());
                    continue;
                }
                for (SQLCreateFunction f : fList) {
                    IUDFunction function = null;
                    switch (f.getSubType()) {
                        case FUNCTION: {
                            function = this.processFunction(jFile, unqJarName, f);
                            break;
                        }
                        case AGGREGATE: {
                            function = this.processAggregate(jFile, f);
                            break;
                        }
                        case PROCEDURE: {
                            function = this.processProcedure(f);
                            break;
                        }
                    }
                    infoLogger.log(f.toString());
                    if (!languages.contains(f.getLanguage())) {
                        errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_LanguageNotSupported, XQEMessages.getCurrProductLocale(), f.getLanguage()));
                    }
                    FunctionManager.registerFunction(function);
                }
            }
        }
        catch (IOException e) {
            infoLogger.log(e);
        }
        return errors;
    }

    private IUDFunction processFunction(JarFile jFile, String jarName, SQLCreateFunction f) {
        String language = f.getLanguage();
        if (language.equals(SQL)) {
            return this.processSQLFunction(f);
        }
        if (language.equals(JAVA)) {
            return this.processJavaFunction(jarName, f);
        }
        return this.processScriptFunction(jFile, f);
    }

    private IUDFunction processSQLFunction(SQLCreateFunction ddlNode) {
        IDataType resultType = ddlNode.getDataType();
        if (resultType instanceof RowType) {
            return new UDSQLTableFunction(ddlNode);
        }
        return new UDSQLScalarFunction(ddlNode);
    }

    private IUDFunction processJavaFunction(String jarName, SQLCreateFunction ddlNode) {
        IDataType resultType = ddlNode.getDataType();
        if (resultType instanceof RowType) {
            return this.processJavaTableFunction(jarName, ddlNode);
        }
        return this.processJavaScalarFunction(jarName, ddlNode);
    }

    private IUDFunction processJavaScalarFunction(String jarName, SQLCreateFunction ddlNode) {
        ErrorList errors = new ErrorList();
        String eName = ddlNode.getExternalName();
        String[] nameParts = this.checkJavaExternalName(eName, errors);
        String className = null;
        String methodName = null;
        Method fMethod = null;
        if (errors.size() == 0) {
            int idx = nameParts[1].lastIndexOf(46);
            className = nameParts[1].substring(0, idx);
            methodName = nameParts[1].substring(idx + 1);
            IDataType[] argumentTypes = ddlNode.getArgumentTypes();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_ClassNotFound, XQEMessages.getCurrProductLocale(), className));
            }
            if (clazz != null) {
                for (Method method : clazz.getMethods()) {
                    if (!method.getName().equals(methodName) || !FunctionManager.isMappable(ddlNode, method, argumentTypes)) continue;
                    fMethod = method;
                    break;
                }
            }
            if (fMethod == null) {
                errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotFound, XQEMessages.getCurrProductLocale(), nameParts[1]));
            } else if (!Modifier.isStatic(fMethod.getModifiers())) {
                errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotStatic, XQEMessages.getCurrProductLocale(), nameParts[1]));
            }
        }
        UDJavaScalarFunction function = new UDJavaScalarFunction(jarName, className, methodName, ddlNode, fMethod, errors);
        return function;
    }

    private IUDFunction processJavaTableFunction(String jarName, SQLCreateFunction ddlNode) {
        ErrorList errors = new ErrorList();
        String eName = ddlNode.getExternalName();
        String[] nameParts = this.checkJavaExternalName(eName, errors);
        Method fMethod = null;
        if (errors.size() == 0) {
            int idx = nameParts[1].lastIndexOf(46);
            String className = nameParts[1].substring(0, idx);
            String methodName = nameParts[1].substring(idx + 1);
            IDataType[] argumentTypes = ddlNode.getArgumentTypes();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_ClassNotFound, XQEMessages.getCurrProductLocale(), className));
            }
            if (clazz != null) {
                for (Method method : clazz.getMethods()) {
                    if (!method.getName().equals(methodName) || !FunctionManager.isMappable(ddlNode, method, argumentTypes)) continue;
                    fMethod = method;
                    break;
                }
            }
            if (fMethod == null) {
                errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotFound, XQEMessages.getCurrProductLocale(), nameParts[1]));
            } else {
                if (!Modifier.isStatic(fMethod.getModifiers())) {
                    errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotStatic, XQEMessages.getCurrProductLocale(), nameParts[1]));
                }
                if (fMethod.getReturnType() != ResultSet.class) {
                    errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_TableFunctionInvalidResultType, XQEMessages.getCurrProductLocale(), nameParts[1]));
                }
            }
        }
        UDJavaTableFunction function = new UDJavaTableFunction(ddlNode, fMethod, errors);
        return function;
    }

    private IUDFunction processScriptFunction(JarFile jFile, SQLCreateFunction ddlNode) {
        IDataType resultType;
        ErrorList errors = new ErrorList();
        String eName = ddlNode.getExternalName();
        String[] nameParts = this.checkScriptExternalName(eName, true, errors);
        InputStream is = null;
        String methodName = null;
        if (errors.size() == 0) {
            nameParts = nameParts[1].split(EXCLAMATION_POINT);
            String fileName = nameParts[0];
            methodName = nameParts[1];
            try {
                ZipEntry jEntry = jFile.getEntry(fileName);
                if (jEntry == null) {
                    errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_ScriptFileNotFound, XQEMessages.getCurrProductLocale(), fileName));
                } else {
                    is = jFile.getInputStream(jEntry);
                }
            }
            catch (IOException jEntry) {
                // empty catch block
            }
        }
        Function function = (resultType = ddlNode.getDataType()) instanceof RowType ? new UDScriptTableFunction(ddlNode, is, methodName, errors) : new UDScriptScalarFunction(ddlNode, is, methodName, errors);
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return function;
    }

    private IUDFunction processAggregate(JarFile jFile, SQLCreateFunction ddlNode) {
        String language = ddlNode.getLanguage().toUpperCase();
        if (language.equals(SQL)) {
            return this.processSQLAggregate(ddlNode);
        }
        if (language.equals(JAVA)) {
            return this.processJavaAggregate(ddlNode);
        }
        return this.processScriptAggregate(jFile, ddlNode);
    }

    private IUDFunction processSQLAggregate(SQLCreateFunction ddlNode) {
        return new UDSQLAggregateFunction(ddlNode);
    }

    /*
     * WARNING - void declaration
     */
    private IUDFunction processJavaAggregate(SQLCreateFunction ddlNode) {
        ErrorList errors = new ErrorList();
        String eName = ddlNode.getExternalName();
        String[] nameParts = this.checkJavaExternalName(eName, errors);
        Method initialize = null;
        Method iterate = null;
        Method remove = null;
        Method getResult = null;
        Method terminate = null;
        if (errors.size() == 0) {
            String className = nameParts[1];
            String fName = ddlNode.getFunctionName();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_ClassNotFound, XQEMessages.getCurrProductLocale(), className));
            }
            if (clazz != null) {
                void var17_36;
                Method method;
                void var17_34;
                String methodName = String.format(S_S, className, "initialize");
                try {
                    initialize = clazz.getDeclaredMethod("initialize", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotFound, XQEMessages.getCurrProductLocale(), methodName));
                }
                if (initialize != null) {
                    Class<?> clazz2;
                    if (!Modifier.isStatic(initialize.getModifiers())) {
                        errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotStatic, XQEMessages.getCurrProductLocale(), methodName));
                    }
                    if (!this.isSerializable(clazz2 = initialize.getReturnType())) {
                        errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotFound, XQEMessages.getCurrProductLocale(), methodName));
                    }
                }
                for (Method method2 : clazz.getDeclaredMethods()) {
                    if (!method2.getName().equals("getResult")) continue;
                    getResult = method2;
                    break;
                }
                methodName = String.format(S_S, className, "getResult");
                if (getResult == null) {
                    errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotFound, XQEMessages.getCurrProductLocale(), methodName));
                } else {
                    Object resultType;
                    Class<?>[] classArray = getResult.getParameterTypes();
                    if (classArray.length != 1 || !this.isSerializable(classArray[0])) {
                        errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotFound, XQEMessages.getCurrProductLocale(), methodName));
                    }
                    if (!Modifier.isStatic(getResult.getModifiers())) {
                        errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotStatic, XQEMessages.getCurrProductLocale(), methodName));
                    }
                    if ((resultType = classMap.get(getResult.getReturnType())) == null) {
                        errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_AggregateFunctionInvalidResultType, XQEMessages.getCurrProductLocale(), fName, getResult.getReturnType().getCanonicalName()));
                    }
                }
                for (Method method3 : clazz.getDeclaredMethods()) {
                    if (!method3.getName().equals("terminate")) continue;
                    terminate = method3;
                    break;
                }
                methodName = String.format(S_S, className, "terminate");
                if (terminate == null) {
                    errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotFound, XQEMessages.getCurrProductLocale(), methodName));
                } else {
                    Class<?>[] classArray;
                    if (!Modifier.isStatic(terminate.getModifiers())) {
                        errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotStatic, XQEMessages.getCurrProductLocale(), methodName));
                    }
                    if ((classArray = terminate.getParameterTypes()).length != 1 || !this.isSerializable(classArray[0])) {
                        errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotFound, XQEMessages.getCurrProductLocale(), methodName));
                    }
                }
                IDataType[] iDataTypeArray = ddlNode.getArgumentTypes();
                Method[] methodArray = clazz.getDeclaredMethods();
                int n = methodArray.length;
                boolean bl = false;
                while (var17_34 < n) {
                    method = methodArray[var17_34];
                    if (method.getName().equals("iterate") && FunctionManager.isMappable(ddlNode, method, iDataTypeArray)) {
                        iterate = method;
                        break;
                    }
                    ++var17_34;
                }
                methodName = String.format(S_S, className, "iterate");
                if (iterate == null) {
                    errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotFound, XQEMessages.getCurrProductLocale(), methodName));
                }
                methodArray = clazz.getDeclaredMethods();
                n = methodArray.length;
                boolean bl2 = false;
                while (var17_36 < n) {
                    method = methodArray[var17_36];
                    if (method.getName().equals("remove") && FunctionManager.isMappable(ddlNode, method, iDataTypeArray)) {
                        remove = method;
                        break;
                    }
                    ++var17_36;
                }
            }
        }
        UDJavaAggregateFunction function = new UDJavaAggregateFunction(ddlNode, initialize, iterate, remove, getResult, terminate, errors);
        return function;
    }

    private boolean isSerializable(Class<?> clazz) {
        boolean result = true;
        Object[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            if (!ArrayUtil.contains(interfaces, Serializable.class)) {
                result = false;
            }
        } else if (clazz != Serializable.class) {
            result = false;
        }
        return result;
    }

    private IUDFunction processScriptAggregate(JarFile jFile, SQLCreateFunction ddlNode) {
        ErrorList errors = new ErrorList();
        String eName = ddlNode.getExternalName();
        String[] nameParts = this.checkScriptExternalName(eName, false, errors);
        InputStream is = null;
        if (errors.size() == 0) {
            String fileName = nameParts[1];
            ZipEntry jEntry = jFile.getEntry(fileName);
            if (jEntry == null) {
                errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_ScriptFileNotFound, XQEMessages.getCurrProductLocale(), fileName));
            }
            try {
                is = jFile.getInputStream(jEntry);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        UDScriptAggregateFunction function = new UDScriptAggregateFunction(ddlNode, is, errors);
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return function;
    }

    public IUDFunction processProcedure(SQLCreateFunction ddlNode) {
        ErrorList errors = new ErrorList();
        String eName = ddlNode.getExternalName();
        String[] nameParts = this.checkJavaExternalName(eName, errors);
        Method fMethod = null;
        if (nameParts.length == 2) {
            int idx = nameParts[1].lastIndexOf(46);
            String className = nameParts[1].substring(0, idx);
            String methodName = nameParts[1].substring(idx + 1);
            IDataType[] argumentTypes = ddlNode.getArgumentTypes();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_ClassNotFound, XQEMessages.getCurrProductLocale(), className));
            }
            if (clazz != null) {
                for (Method method : clazz.getMethods()) {
                    if (!method.getName().equals(methodName) || !FunctionManager.isMappable(ddlNode, method, argumentTypes)) continue;
                    fMethod = method;
                    break;
                }
            }
            if (fMethod == null) {
                errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotFound, XQEMessages.getCurrProductLocale(), nameParts[1]));
            } else if (!Modifier.isStatic(fMethod.getModifiers())) {
                errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_MethodNotStatic, XQEMessages.getCurrProductLocale(), nameParts[1]));
            }
        }
        UDProcedure function = new UDProcedure(ddlNode, fMethod, errors);
        return function;
    }

    private String[] checkJavaExternalName(String eName, ErrorList errors) {
        String[] nameParts = eName.split(COLON);
        if (nameParts.length < 2 || !nameParts[0].equals(THISJAR) || nameParts[1].lastIndexOf(46) < 0) {
            errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_InvalidExternalName, XQEMessages.getCurrProductLocale(), eName));
        }
        return nameParts;
    }

    private String[] checkScriptExternalName(String eName, boolean isScalarFunction, ErrorList errors) {
        String[] nameParts = eName.split(COLON);
        boolean isValid = true;
        if (nameParts.length < 2 || !nameParts[0].equals(THISJAR)) {
            isValid = false;
        } else if (isScalarFunction) {
            boolean bl = isValid = nameParts[1].split(EXCLAMATION_POINT).length == 2;
        }
        if (!isValid) {
            errors.add(XQEMessages.getMessage(XQEMessageKeys.UDF_InvalidExternalName, XQEMessages.getCurrProductLocale(), eName));
        }
        return nameParts;
    }

    public static IFunction getFunction(String name) {
        return FunctionManager.getBuiltinFunction(name);
    }

    public static IFunction getBuiltinFunction(String name) {
        IFunction result = bifShareableDirectory.get(name);
        if (result != null) {
            return result;
        }
        Class<?> fClass = null;
        fClass = bifNonShareableDirectory.get(name);
        if (fClass != null) {
            try {
                result = (IFunction)fClass.newInstance();
            }
            catch (Exception e) {
                result = null;
            }
            return result;
        }
        int nPackages = bifClasses.size();
        block4: for (int i = 0; i < nPackages && fClass == null; ++i) {
            Class<?>[] classes = bifClasses.get(i);
            int nFunctions = classes.length;
            for (int j = 0; j < nFunctions; ++j) {
                String className = classes[j].getName();
                String simpleName = className.substring(className.lastIndexOf(46) + 1);
                if (!simpleName.equalsIgnoreCase(name)) continue;
                fClass = classes[j];
                continue block4;
            }
        }
        if (fClass == null) {
            return null;
        }
        try {
            result = (IFunction)fClass.newInstance();
        }
        catch (Exception e) {
            result = null;
        }
        if (result != null) {
            if (result.isShareable()) {
                bifShareableDirectory.put(name, result);
            } else {
                bifNonShareableDirectory.put(name, fClass);
            }
        }
        return result;
    }

    public static List<Class<?>[]> getBuiltInFunctionClassList() {
        return bifClasses;
    }

    public static IFunction getBuiltinFunction(String name, IDataType[] argTypes) {
        return FunctionManager.getBuiltinFunction(name);
    }

    public static IFunction getFunction(String name, IDataType[] argTypes) {
        IFunction result = FunctionManager.getBuiltinFunction(name);
        if (result == null) {
            result = FunctionManager.getUserDefinedFunction(name, argTypes);
        }
        return result;
    }

    public static IFunction getFunction(String name, IDataType[] argTypes, boolean udf) {
        IFunction result = udf ? FunctionManager.getUserDefinedFunction(name, argTypes) : FunctionManager.getBuiltinFunction(name);
        return result;
    }

    public static IFunction getUserDefinedFunction(String name, IDataType[] argTypes) {
        List<IUDFunction> fList;
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (argTypes[i] != null) continue;
                argTypes[i] = DataTypeFactory.getObjectType();
            }
        }
        if ((fList = udfDirectory.get(name.toLowerCase())) != null) {
            IFunction function;
            if (argTypes == null) {
                for (IUDFunction function2 : fList) {
                    if (function2.getArgumentCount() != 0) continue;
                    return FunctionManager.validate(function2);
                }
            }
            if ((function = FunctionManager.findBestFit(CollectionCast.upcast(fList, IFunction.class), argTypes)) != null) {
                return FunctionManager.validate(function);
            }
        }
        return null;
    }

    private static IFunction validate(IFunction function) {
        IFunctionState func;
        if (function instanceof IFunctionState && !(func = (IFunctionState)((Object)function)).isValid()) {
            ErrorList errors = func.getErrors();
            StringBuilder msgBuilder = new StringBuilder();
            for (String error : errors) {
                msgBuilder.append("\n");
                msgBuilder.append(error);
            }
            String message = msgBuilder.toString();
            if (function.isScalarFunction()) {
                throw new XQERuntimeException(XQEMessageKeys.UDF_ScalarFunctionNotValid, function.getName(), message);
            }
            if (function.isAggregate()) {
                throw new XQERuntimeException(XQEMessageKeys.UDF_AggregateFunctionNotValid, function.getName(), message);
            }
            if (function.isTableFunction()) {
                throw new XQERuntimeException(XQEMessageKeys.UDF_TableFunctionNotValid, function.getName(), message);
            }
        }
        return function;
    }

    private static IFunction findBestFit(List<IFunction> fList, IDataType[] argTypes) {
        int bestRank = -1;
        IFunction bestMatch = null;
        for (IFunction function : fList) {
            int rank;
            if (!function.hasSignature(argTypes, false) || (rank = function.getSignatureRank(argTypes)) < 0 || bestRank >= 0 && rank >= bestRank) continue;
            bestRank = rank;
            bestMatch = function;
        }
        return bestMatch;
    }

    public static IUDFunction getUserDefinedFunction(String mangledName) {
        String name = mangledName.substring(2, mangledName.lastIndexOf(95));
        int id = Integer.valueOf(mangledName.substring(mangledName.lastIndexOf(95) + 1));
        List<IUDFunction> fList = udfDirectory.get(name.toLowerCase());
        return fList.get(id);
    }

    public static IFunction getUserDefinedProcedure(String name, IDataType[] argTypes) {
        List<IUDFunction> fList = udfDirectory.get(name.toLowerCase());
        if (fList != null) {
            for (IUDFunction function : fList) {
                if (!(function instanceof UDProcedure) || !function.hasSignature(argTypes)) continue;
                return function;
            }
        }
        return null;
    }

    private static void registerFunction(IUDFunction function) {
        String fName = function.getName().toLowerCase();
        List<IUDFunction> fList = udfDirectory.get(fName);
        if (fList == null) {
            fList = new ArrayList<IUDFunction>();
            udfDirectory.put(fName, fList);
        }
        function.setMangledName(String.format("__%s_%d", function.getName(), fList.size()));
        fList.add(function);
    }

    private static boolean isMappable(SQLCreateFunction fNode, Method fMethod, IDataType[] argumentTypes) {
        Class<?>[] argTypes = fMethod.getParameterTypes();
        switch (fNode.getSubType()) {
            case FUNCTION: {
                if (argTypes.length != argumentTypes.length) {
                    return false;
                }
                return FunctionManager.argumentsAreCompatible(fMethod, argTypes, argumentTypes, 0);
            }
            case AGGREGATE: {
                if (argTypes.length != argumentTypes.length + 1) {
                    return false;
                }
                if (argTypes[0] != Serializable.class && !ArrayUtil.contains(argTypes[0].getInterfaces(), Serializable.class)) {
                    return false;
                }
                return FunctionManager.argumentsAreCompatible(fMethod, argTypes, argumentTypes, 1);
            }
            case PROCEDURE: {
                if (fNode.getMaxResultSets() == 0 ? argTypes.length != argumentTypes.length : argTypes.length != argumentTypes.length + 1) {
                    return false;
                }
                if (!FunctionManager.argumentsAreCompatible(fMethod, argTypes, argumentTypes, 0)) {
                    return false;
                }
                for (int j = argumentTypes.length; j < argTypes.length; ++j) {
                    Class<?> argType = argTypes[j];
                    if (argType.isArray() && argType.getComponentType() == ResultSet.class) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    private static boolean argumentsAreCompatible(Method fMethod, Class<?>[] argTypes, IDataType[] argumentTypes, int start) {
        for (int j = 0; j < argumentTypes.length; ++j) {
            Class<?> argType = argTypes[j + start];
            byte cclTypeCode = argumentTypes[j].getCCLTypeCode();
            Class<?>[] types = null;
            types = cclTypeCode == 22 ? subTypeMap.get((Object)argumentTypes[j].getSubType()) : typeMap.get(argumentTypes[j].getCCLTypeCode());
            boolean mappable = false;
            for (int k = 0; k < types.length; ++k) {
                if (types[k] != argType && !types[k].isAssignableFrom(argType) && !argType.isAssignableFrom(types[k]) && (classMap.get(argType) != null || types[k] != Object.class) && (!fMethod.isVarArgs() || !argType.isArray() || argType.getComponentType() != types[k])) continue;
                mappable = true;
                break;
            }
            if (mappable) continue;
            return false;
        }
        return true;
    }

    public static boolean isUserDefinedAggregate(String functionName, IDataType[] argTypes) {
        List<IUDFunction> fList = udfDirectory.get(functionName);
        if (fList != null) {
            for (IUDFunction function : fList) {
                if (!function.isAggregate() || !function.hasSignature(argTypes)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<IUDFunction> getUserDefinedFunctions() {
        ArrayList<IUDFunction> result = new ArrayList<IUDFunction>();
        for (Map.Entry<String, List<IUDFunction>> entry : udfDirectory.entrySet()) {
            List<IUDFunction> functions = entry.getValue();
            for (IUDFunction function : functions) {
                if (function.isSQLFunction()) continue;
                result.add(function);
            }
        }
        return result;
    }

    public static List<IUDFunction> getUserDefinedFunctions(String name) {
        return udfDirectory.get(name);
    }

    static {
        classMap.put(Character.TYPE, (byte)2);
        classMap.put(Short.TYPE, (byte)4);
        classMap.put(Integer.TYPE, (byte)6);
        classMap.put(Long.TYPE, (byte)8);
        classMap.put(Float.TYPE, (byte)10);
        classMap.put(Double.TYPE, (byte)11);
        classMap.put(Boolean.TYPE, (byte)51);
        classMap.put(byte[].class, (byte)23);
        classMap.put(Object.class, (byte)105);
        classMap.put(Short.class, (byte)4);
        classMap.put(Integer.class, (byte)6);
        classMap.put(Long.class, (byte)8);
        classMap.put(BigDecimal.class, (byte)12);
        classMap.put(Float.class, (byte)10);
        classMap.put(Double.class, (byte)11);
        classMap.put(Boolean.class, (byte)51);
        classMap.put(String.class, (byte)45);
        classMap.put(Date.class, (byte)57);
        classMap.put(java.sql.Date.class, (byte)57);
        classMap.put(Time.class, (byte)58);
        classMap.put(Timestamp.class, (byte)59);
        classMap.put(Blob.class, (byte)18);
        classMap.put(Clob.class, (byte)46);
        classMap.put(BinaryValue.class, (byte)23);
        classMap.put(VarBinaryValue.class, (byte)24);
        classMap.put(BooleanValue.class, (byte)51);
        classMap.put(SmallintValue.class, (byte)4);
        classMap.put(IntegerValue.class, (byte)6);
        classMap.put(LongValue.class, (byte)8);
        classMap.put(DecimalValue.class, (byte)12);
        classMap.put(FloatValue.class, (byte)10);
        classMap.put(DoubleValue.class, (byte)11);
        classMap.put(DateValue.class, (byte)57);
        classMap.put(TimeValue.class, (byte)58);
        classMap.put(TimeWithTZValue.class, (byte)52);
        classMap.put(TimestampValue.class, (byte)59);
        classMap.put(TimestampWithTZValue.class, (byte)53);
        classMap.put(PeriodValue.class, new Byte[]{(byte)108, (byte)109, (byte)110, (byte)111, (byte)112});
        classMap.put(String[].class, (byte)102);
        classMap.put(Short[].class, (byte)102);
        classMap.put(Integer[].class, (byte)102);
        classMap.put(Long[].class, (byte)102);
        classMap.put(BigDecimal[].class, (byte)102);
        classMap.put(Float[].class, (byte)102);
        classMap.put(Double[].class, (byte)102);
        classMap.put(Date[].class, (byte)102);
        classMap.put(java.sql.Date[].class, (byte)102);
        classMap.put(Time[].class, (byte)102);
        classMap.put(Timestamp[].class, (byte)102);
        classMap.put(ArrayValue.class, (byte)102);
        classMap.put(ResultSet.class, (byte)103);
        classMap.put(JSONValue.class, (byte)114);
        typeMap = new HashMap<Byte, Class<?>[]>();
        typeMap.put((byte)51, new Class[]{Boolean.TYPE, Boolean.class, BooleanValue.class});
        typeMap.put((byte)2, new Class[]{Character.TYPE});
        typeMap.put((byte)4, new Class[]{Short.TYPE, Short.class, SmallintValue.class});
        typeMap.put((byte)6, new Class[]{Integer.TYPE, Integer.class, IntegerValue.class});
        typeMap.put((byte)8, new Class[]{Long.TYPE, Long.class, LongValue.class});
        typeMap.put((byte)10, new Class[]{Float.TYPE, Float.class, FloatValue.class});
        typeMap.put((byte)11, new Class[]{Double.TYPE, Double.class, DoubleValue.class});
        typeMap.put((byte)23, new Class[]{byte[].class, BinaryValue.class});
        typeMap.put((byte)24, new Class[]{byte[].class, VarBinaryValue.class});
        typeMap.put((byte)12, new Class[]{BigDecimal.class, BigDecimalValue.class});
        typeMap.put((byte)1, new Class[]{String.class});
        typeMap.put((byte)45, new Class[]{String.class, CharValue.class, NCharValue.class, VarcharValue.class, NVarcharValue.class});
        typeMap.put((byte)55, new Class[]{String.class, CharValue.class, NCharValue.class, VarcharValue.class, NVarcharValue.class});
        typeMap.put((byte)56, new Class[]{String.class, CharValue.class, NCharValue.class, VarcharValue.class, NVarcharValue.class});
        typeMap.put((byte)57, new Class[]{java.sql.Date.class, Date.class, DateValue.class});
        typeMap.put((byte)58, new Class[]{Time.class, TimeValue.class});
        typeMap.put((byte)52, new Class[]{Time.class, TimeWithTZValue.class});
        typeMap.put((byte)59, new Class[]{Timestamp.class, TimestampValue.class});
        typeMap.put((byte)53, new Class[]{Timestamp.class, TimestampWithTZValue.class});
        typeMap.put((byte)18, new Class[]{Blob.class, BlobValue.class});
        typeMap.put((byte)46, new Class[]{String.class, Clob.class, ClobValue.class});
        typeMap.put((byte)105, new Class[]{Object.class, ObjectValue.class});
        typeMap.put((byte)108, new Class[]{PeriodValue.class});
        typeMap.put((byte)109, new Class[]{PeriodValue.class});
        typeMap.put((byte)110, new Class[]{PeriodValue.class});
        typeMap.put((byte)111, new Class[]{PeriodValue.class});
        typeMap.put((byte)112, new Class[]{PeriodValue.class});
        typeMap.put((byte)102, new Class[]{String[].class, short[].class, int[].class, long[].class, float[].class, double[].class, Short[].class, Integer[].class, Long[].class, BigDecimal[].class, Float[].class, Double[].class, Date[].class, java.sql.Date[].class, Time[].class, Timestamp[].class});
        typeMap.put((byte)103, new Class[]{ResultSet.class});
        typeMap.put((byte)114, new Class[]{String.class, JSONValue.class});
        subTypeMap = new HashMap<DataSubType, Class<?>[]>();
        subTypeMap.put(DataSubType.TEXTTYPE, new Class[]{String.class});
        subTypeMap.put(DataSubType.NUMERICTYPE, new Class[]{Number.class});
        subTypeMap.put(DataSubType.DATETIMETYPE, new Class[]{java.sql.Date.class, Time.class, Timestamp.class});
        subTypeMap.put(DataSubType.ANYTYPE, new Class[]{Object.class, String.class, Number.class});
        languages = new ArrayList<String>();
        infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Configuration", LogLevel.INFO);
        errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Configuration", LogLevel.ERROR);
        instance = new FunctionManager();
    }
}

