/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.character;

import com.cognos.xqe.data.types.ClobType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IPosition;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Position
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{1, 45, 55, 56, 107, 23, 24}, {1, 45, 55, 56, 46, 107, 23, 24}};

    public Position() {
        super("Position", ACCEPTED_TYPES, true);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Position.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        if (oDataTypes[1] == ClobType.CLOBTYPE) {
            return DataTypeFactory.getLongType();
        }
        return DataTypeFactory.getIntegerType();
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) throws XQERuntimeException {
        Value input1 = (Value)pEvaluator.getParameter(context, 0);
        IPosition input2 = (IPosition)pEvaluator.getParameter(context, 1);
        if (input1.isNull() || input2.isNull()) {
            output.setNull();
            return;
        }
        ((Value)output).set(input2.position(input1));
    }
}

