/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.character;

import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.ITextValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.StringFunction;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.ArrayUtil;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;

public class Substring
extends StringFunction {
    public static final String FUNCTION_NAME = "Substring";
    public static final byte[][] ACCEPTED_TYPES;
    static boolean mReturnTextType;

    public Substring() {
        super(FUNCTION_NAME, ACCEPTED_TYPES, true, 2);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Substring.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        IDataType dt = Substring.getStringTypeForOlapMetadata(oDataTypes, 0);
        if (mReturnTextType && !ArrayUtil.contains(DataTypeCode.ALL_TEXT_TYPES, dt.getCCLTypeCode())) {
            dt = DataTypeFactory.getVarcharType();
        }
        return dt;
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) throws XQERuntimeException {
        Value input = (Value)pEvaluator.getParameter(context, 0);
        Value outputValue = (Value)output;
        if (input.isNull()) {
            output.setNull();
            return;
        }
        String str = ((ITextValue)((Object)input)).getString();
        int inputStrLenInCodeunits = str.length();
        int inputStrLenInChars = Character.codePointCount(str, 0, inputStrLenInCodeunits);
        int startPosition = ((Value)pEvaluator.getParameter(context, 1)).getInteger();
        if (startPosition > inputStrLenInChars) {
            outputValue.set("");
            return;
        }
        int numberOfChars = inputStrLenInChars;
        if (pEvaluator.getParameterCount() == ACCEPTED_TYPES.length) {
            numberOfChars = ((Value)pEvaluator.getParameter(context, 2)).getInteger();
            if (startPosition < 1) {
                if (numberOfChars < 0) {
                    outputValue.set(str);
                    return;
                }
                outputValue.set("");
                return;
            }
            if (numberOfChars < 0) {
                int cpOffset = str.offsetByCodePoints(0, --startPosition);
                outputValue.set(str.substring(cpOffset));
                return;
            }
        } else if (startPosition < 0) {
            if (startPosition + inputStrLenInChars < 0) {
                outputValue.set("");
                return;
            }
            outputValue.set(str);
            return;
        }
        if (numberOfChars < 1) {
            outputValue.set("");
            return;
        }
        if (startPosition == 0) {
            startPosition = 1;
        }
        if (startPosition < 0) {
            startPosition = startPosition + inputStrLenInChars + 1;
        }
        if (startPosition < 1) {
            outputValue.set("");
            return;
        }
        int endPosition = startPosition + numberOfChars;
        int begin = str.offsetByCodePoints(0, --startPosition);
        if (--endPosition >= inputStrLenInChars) {
            outputValue.set(str.substring(begin));
        } else {
            int end = str.offsetByCodePoints(0, endPosition);
            outputValue.set(str.substring(begin, end));
        }
    }

    static {
        MultiRequestContext multiRequestContext;
        XQEConfiguration configuration;
        ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TEXT_TYPES, {6, 8, 2, 4, 12, 10, 11}, {6, 8, 2, 4, 12, 10, 11}};
        mReturnTextType = true;
        if (ExecutionEnvironmentContext.getExecutionEnvironment() != null && (configuration = (multiRequestContext = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext()).getXQEConfiguration()) != null) {
            mReturnTextType = multiRequestContext.fetchBooleanConfiguration("queryPlanning.substringReturnsString[@value]", true);
        }
    }
}

