/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.character;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.ITextValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.StringFunction;
import com.cognos.xqe.runtree.XDataContext;

public class SubstringR
extends StringFunction {
    public static final String FUNCTION_NAME = "SubstringR";
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TEXT_TYPES, {6, 8, 2, 4, 12, 10, 11}, {6, 8, 2, 4, 12, 10, 11}};

    public SubstringR() {
        super(FUNCTION_NAME, ACCEPTED_TYPES, true, 2);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return SubstringR.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return SubstringR.getStringTypeForOlapMetadata(oDataTypes, 0);
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) throws XQERuntimeException {
        Value input = (Value)pEvaluator.getParameter(context, 0);
        Value outputValue = (Value)output;
        if (input.isNull()) {
            output.setNull();
            return;
        }
        String str = ((ITextValue)((Object)input)).getString();
        int inputStrLenInCodeunits = str.length();
        int inputStrLenInChars = Character.codePointCount(str, 0, inputStrLenInCodeunits);
        int startPosition = ((Value)pEvaluator.getParameter(context, 1)).getInteger();
        if (startPosition == 0) {
            startPosition = 1;
        }
        if (startPosition < 0) {
            startPosition = startPosition + inputStrLenInCodeunits + 1;
        }
        if (startPosition < 1 || startPosition > inputStrLenInChars) {
            outputValue.setNull();
            return;
        }
        int numberOfChars = inputStrLenInChars - startPosition + 1;
        if (pEvaluator.getParameterCount() == ACCEPTED_TYPES.length) {
            numberOfChars = ((Value)pEvaluator.getParameter(context, 2)).getInteger();
        }
        if (numberOfChars < 1) {
            outputValue.setNull();
            return;
        }
        int endPosition = startPosition + numberOfChars;
        int begin = str.offsetByCodePoints(0, --startPosition);
        if (--endPosition >= inputStrLenInChars) {
            outputValue.set(str.substring(begin));
        } else {
            int end = str.offsetByCodePoints(0, endPosition);
            outputValue.set(str.substring(begin, end));
        }
    }
}

