/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.character;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.StringFunction;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.icu.text.Transliterator;

public class Translate
extends StringFunction {
    public static final String FUNCTION_NAME = "Translate";
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TEXT_TYPES, DataTypeCode.ALL_TEXT_TYPES};

    public Translate() {
        super(FUNCTION_NAME, ACCEPTED_TYPES, true);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Translate.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return Translate.getStringTypeForOlapMetadata(oDataTypes, 0);
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) throws XQERuntimeException {
        IValue input1 = pEvaluator.getParameter(context, 0);
        IValue input2 = pEvaluator.getParameter(context, 1);
        if (input1.isNull() || input2.isNull()) {
            output.setNull();
        } else {
            try {
                Transliterator transLiterator = Transliterator.getInstance((String)input2.toString());
                String result = transLiterator.transliterate(input1.toString());
                ((Value)output).set(result);
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
        }
    }
}

