/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.collection;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class TrimArray
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{102}, DataTypeCode.ALL_NUMERIC_TYPES};

    public TrimArray() {
        super("TrimArray", "trim_array", ACCEPTED_TYPES, true);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] ins) {
        return ins[0];
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        ArrayValue input = (ArrayValue)pEvaluator.getParameter(context, 0);
        NumericValue nElements = (NumericValue)pEvaluator.getParameter(context, 1);
        ArrayValue output = (ArrayValue)outputArg;
        output.setNull();
        if (!input.isNull() && !nElements.isNull()) {
            output.set(input, nElements.getInteger());
        }
    }
}

