/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.collection;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.ICollection;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.MultisetValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.TableFunction;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import java.util.ArrayList;
import java.util.Iterator;

public class Unnest
extends TableFunction {
    public static final String WITH_ORDINALITY = "WITH ORDINALITY";
    public static final String WITHOUT_ORDINALITY = "WITHOUT ORDINALITY";
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{102}};

    public Unnest() {
        super("Unnest", ACCEPTED_TYPES, true);
    }

    @Override
    public IHybridResultSet execute(XDataContext context, IParameterEvaluator pEvaluator, IRowsetInfo rowsetInfo) throws XQERuntimeException {
        return new TabularHybridResultSet(context, new UnnestResultSet(context, pEvaluator, rowsetInfo));
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] ins) {
        return DataTypeFactory.getXmlType();
    }

    private final class UnnestResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IParameterEvaluator pEvaluator;

        UnnestResultSet(XDataContext context, IParameterEvaluator parameterEvaluator, IRowsetInfo theRowsetInfo) {
            super(context, context.getNodeId());
            this.pEvaluator = parameterEvaluator;
            this.rowsetInfo = theRowsetInfo;
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new UnnestIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
        }

        private final class UnnestIterator
        extends XTabularIterator {
            private int nParameters;
            private Iterator<IValue> iterator;
            private ArrayList<Iterator<IValue>> iterators;
            private int[] cardinalities;
            private int maxCardinality;
            private boolean withOrdinality;
            private RowValue row;

            private UnnestIterator(XDataContext context) {
                super(context, context.getNodeId());
                this.nParameters = UnnestResultSet.this.pEvaluator.getParameterCount() - 1;
                IValue[] parameters = UnnestResultSet.this.pEvaluator.getParameters(context);
                String firstArg = ((Value)parameters[0]).getString();
                this.withOrdinality = firstArg.equals(Unnest.WITH_ORDINALITY);
                if (parameters[1] instanceof MultisetValue) {
                    this.iterator = ((ICollection)((Object)parameters[1])).iterator();
                } else {
                    this.iterators = new ArrayList();
                    this.cardinalities = new int[this.nParameters];
                    for (int i = 0; i < this.nParameters; ++i) {
                        ICollection collection = (ICollection)((Object)parameters[i + 1]);
                        this.cardinalities[i] = collection.size();
                        this.maxCardinality = Math.max(this.maxCardinality, this.cardinalities[i]);
                        this.iterators.add(collection.iterator());
                    }
                }
                this.row = DataValueFactory.createRowValue(context.getLocalCollator(), UnnestResultSet.this.rowsetInfo);
            }

            @Override
            public Object nextImpl() {
                if (this.iterator != null) {
                    if (!this.iterator.hasNext()) {
                        return null;
                    }
                    ++this.nRows;
                    this.row.copyFrom(this.iterator.next());
                } else {
                    if (this.nRows == this.maxCardinality) {
                        return null;
                    }
                    ++this.nRows;
                    int i = 0;
                    if (this.withOrdinality) {
                        ((Value)this.row.getColumn(0)).set(this.nRows);
                        ++i;
                    }
                    for (int j = 0; j < this.nParameters; ++j) {
                        IValue value = this.row.getColumn(i++);
                        if (this.cardinalities[j] >= this.nRows) {
                            value.copyFrom(this.iterators.get(j).next());
                            continue;
                        }
                        value.setNull();
                    }
                }
                return this.row;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }
        }
    }
}

