/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.conditional;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class NullIf
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES};

    public NullIf() {
        super("NullIf", ACCEPTED_TYPES);
    }

    @Override
    public boolean isMetadataTypeArgumentAllowed() {
        return true;
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return NullIf.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return oDataTypes[0];
    }

    @Override
    public void validateArgumentTypesImpl(IDataType[] fArgumentTypes) {
        if (!DataTypeComparator.isComparableTo(fArgumentTypes[0], fArgumentTypes[1])) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_IncompatibleArgumentTypes, (Object)fArgumentTypes[0].toString(), (Object)fArgumentTypes[1].toString(), (Object)this.getName().toLowerCase());
        }
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) throws XQERuntimeException {
        Value parm = (Value)pEvaluator.getParameter(context, 0);
        if (parm.compareTo(pEvaluator.getParameter(context, 1)) == 0) {
            output.setNull();
        } else {
            ((Value)output).set(parm);
        }
    }

    @Override
    public boolean isNullable(boolean[] argNullable) {
        return true;
    }
}

