/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.conditional;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class SimpleCase
extends ScalarFunction {
    private static final int VARIABLE_ARG_IDX = 2;
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES};

    @Override
    public boolean isMetadataTypeArgumentAllowed() {
        return true;
    }

    public SimpleCase() {
        super("SimpleCase", ACCEPTED_TYPES, 2);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return SimpleCase.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        IDataType result = oDataTypes[oDataTypes.length - 1];
        for (int i = 2; i < oDataTypes.length; i += 2) {
            result = DataTypeComparator.getCompatibleType(result, oDataTypes[i]);
        }
        return result;
    }

    @Override
    public void validateArgumentTypesImpl(IDataType[] fArgumentTypes) {
        IDataType result = fArgumentTypes[fArgumentTypes.length - 1];
        for (int i = 2; i < fArgumentTypes.length; i += 2) {
            if (DataTypeComparator.isComparableTo(result, fArgumentTypes[i])) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_IncompatibleArgumentTypes, (Object)result.toString(), (Object)fArgumentTypes[i].toString(), (Object)this.getName().toLowerCase());
        }
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) throws XQERuntimeException {
        int numArgs = pEvaluator.getParameterCount();
        IValue expression = null;
        int elseResultPos = -1;
        if (numArgs % 2 == 0) {
            elseResultPos = --numArgs;
        }
        expression = pEvaluator.getParameter(context, 0);
        for (int i = 1; i < numArgs; i += 2) {
            IValue searchExpression = pEvaluator.getParameter(context, i);
            if (searchExpression.isNull() || expression.isNull() || searchExpression.compareTo(expression) != 0) continue;
            output.copyFrom(pEvaluator.getParameter(context, i + 1));
            return;
        }
        if (elseResultPos != -1) {
            output.copyFrom(pEvaluator.getParameter(context, elseResultPos));
        } else {
            output.setNull();
        }
    }

    @Override
    public boolean isNullable(boolean[] argNullable) {
        boolean nullable = false;
        int nArgs = argNullable.length;
        int i = 2;
        if (nArgs % 2 == 0) {
            nullable = argNullable[0];
            ++i;
        }
        while (i < nArgs && !nullable) {
            nullable = argNullable[i];
            i += 2;
        }
        return nullable;
    }
}

