/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.convert;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLCast;
import com.cognos.xqe.ast.sql.SQLFormat;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.providers.relational.LOCALCastFormatter;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.ExactNumericValue;
import com.cognos.xqe.data.values.FloatValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XFormat;
import com.cognos.xqe.runtree.relational.XScalarFunction;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.ibm.icu.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

public class Cast
extends ScalarFunction {
    private static XQELogger mCastLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryEngine", LogLevel.INFO);
    public static final int TWO = 2;
    public static final int THREE = 3;
    public static final int MIN_ARGS = 2;
    public static final int MAX_ARGS = 3;
    private static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TEXT_TYPES};

    public Cast() {
        super("Cast", ACCEPTED_TYPES, true, 2, 3);
    }

    public ObjectValue retrieveFormatValue(XDataContext context, IParameterEvaluator pEvaluator) {
        block3: {
            block2: {
                if (!(pEvaluator instanceof SQLCast)) break block2;
                for (int i = 0; i < ((SQLCast)pEvaluator).getNumberChildren(); ++i) {
                    if (!(((SQLCast)pEvaluator).getChild(i) instanceof SQLFormat)) continue;
                    return (ObjectValue)pEvaluator.getParameter(context, i);
                }
                break block3;
            }
            if (!(pEvaluator instanceof XScalarFunction)) break block3;
            for (int i = 0; i < ((XScalarFunction)pEvaluator).getNumberChildren(); ++i) {
                if (!(((XScalarFunction)pEvaluator).getChild(i) instanceof XFormat)) continue;
                return (ObjectValue)pEvaluator.getParameter(context, i);
            }
        }
        return null;
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) {
        IValue input = pEvaluator.getParameter(context, 0);
        SQLAbstractFunction.OnErrorPolicy onErrorPolicy = pEvaluator.getOnErrorPolicy();
        if (input.isNull()) {
            output.setNull();
            return;
        }
        ObjectValue formatValue = this.retrieveFormatValue(context, pEvaluator);
        try {
            IDataType dataType = input.getDataType();
            if (dataType == MemberType.MEMBERTYPE) {
                String sInput = input.toString();
                StringValue tInput = DataValueFactory.createStringValue();
                tInput.set(sInput);
                output.copyFrom(tInput);
            } else if (dataType instanceof TimeType && output.getDataType() instanceof TimestampType) {
                ((Value)output).copyFrom(context, input);
            } else if (input instanceof ContextValue) {
                output.copyFrom(((ContextValue)input).getValue());
            } else if (input instanceof NumericValue && !(input instanceof ExactNumericValue) && output instanceof TextValue) {
                DecimalFormat formatter = new DecimalFormat();
                if (input instanceof FloatValue) {
                    formatter.applyPattern("0.0#####E+00");
                } else {
                    formatter.applyPattern("0.0###############E+00");
                }
                String val = formatter.format(((NumericValue)input).getObject());
                ((TextValue)output).setState(ValueState.OK);
                ((TextValue)output).setValue(val);
            } else if (input.getDataType().isTextType() && (output.getDataType().isDate() || output.getDataType().isTime() || output.getDataType().isTimestamp()) && formatValue != null && !formatValue.isNull()) {
                Object[] obj = (Object[])formatValue.getObject();
                DateTimeFormatter dtf = (DateTimeFormatter)obj[0];
                ArrayList accessors = (ArrayList)obj[1];
                String convertedValue = LOCALCastFormatter.getInstance().convertToISOStandardFormat(input.toString(), output.getDataType(), accessors, dtf);
                ((DateTimeValue)output).set(convertedValue);
            } else {
                output.copyFrom(input);
            }
            if (output instanceof TextValue && ((TextValue)output).getCollator() == null) {
                ((TextValue)output).setCollator(context.getLocalCollator());
            }
            ((Value)output).validate(dataType, mCastLogger);
        }
        catch (ValueConversionException e) {
            if (onErrorPolicy == SQLAbstractFunction.OnErrorPolicy.ERROR) {
                throw e;
            }
            output.setNull();
        }
        catch (RuntimeException e) {
            if (onErrorPolicy == SQLAbstractFunction.OnErrorPolicy.ERROR) {
                throw e;
            }
            output.setNull();
        }
    }

    @Override
    public boolean isMetadataTypeArgumentAllowed() {
        return true;
    }

    @Override
    public boolean hasVariantTypeArguments(IDataType[] fArgumentTypes) {
        return false;
    }

    public boolean validArgumentTypesImpl(IDataType[] fArgumentTypes) {
        return DataTypeComparator.isValidCast(fArgumentTypes[0], fArgumentTypes[1]);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Cast.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return oDataTypes[1];
    }
}

