/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.date;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class AddQuarters
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{57, 59, 53}, {6, 2, 4, 8, 12}};

    public AddQuarters() {
        super("AddQuarters", ACCEPTED_TYPES, true);
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        IValue input1 = pEvaluator.getParameter(context, 0);
        NumericValue input2 = (NumericValue)pEvaluator.getParameter(context, 1);
        DateTimeValue output = (DateTimeValue)outputArg;
        if (!input1.isNull() && !input2.isNull()) {
            output.copyFrom(input1);
            output.addQuarters(input2.getInteger());
        } else {
            output.setNull();
        }
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return AddQuarters.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        int cclDType = 0;
        if (oDataTypes.length > 0 && oDataTypes[0] != null) {
            cclDType = oDataTypes[0].getCCLTypeCode();
        }
        if (cclDType == 0 || cclDType == 34 || cclDType == 1) {
            return DataTypeFactory.getTimestampType();
        }
        return oDataTypes[0];
    }
}

