/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.date;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class DayOfWeek
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{57, 59, 53}, {4, 6, 8}};

    public DayOfWeek() {
        super("DayOfWeek", "day_of_week", ACCEPTED_TYPES, true);
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        DateTimeValue input = (DateTimeValue)pEvaluator.getParameter(context, 0);
        Value input2 = (Value)pEvaluator.getParameter(context, 1);
        IntegerValue output = (IntegerValue)outputArg;
        if (!input.isNull() && !input2.isNull()) {
            int dow = input.dayOfWeek();
            int beginningOfWeek = input2.getInteger();
            if (beginningOfWeek != 1 && (dow -= beginningOfWeek - 1) < 1) {
                dow += 7;
            }
            output.set(dow);
        } else {
            output.setNull();
        }
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return DayOfWeek.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getIntegerType();
    }
}

