/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.date;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class DaysToEndOfMonth
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{57, 59, 53}};

    public DaysToEndOfMonth() {
        super("DaysToEndOfMonth", "days_to_end_of_month", ACCEPTED_TYPES, true);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] argumentTypes) {
        return DaysToEndOfMonth.getOutputType(argumentTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return IntegerType.INTEGERTYPE;
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDateType();
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator evaluator, IValue outputArg) throws XQERuntimeException {
        DateTimeValue input = (DateTimeValue)evaluator.getParameter(context, 0);
        if (input.isNull()) {
            outputArg.setNull();
        } else {
            int i = input.getCalendar().getActualMaximum(5);
            ((Value)outputArg).set(i - input.getDay());
        }
    }
}

