/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.date;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.util.GregorianCalendar;

public class YMDIntBetween
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{57, 59, 53}, {57, 59, 53}};
    private static final int YEAR_MULTIPLIER = 10000;
    private static final int MONTH_MULTIPLIER = 100;

    public YMDIntBetween() {
        super("YMDIntBetween", ACCEPTED_TYPES, true);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] argumentTypes) {
        return YMDIntBetween.getOutputType(argumentTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return IntegerType.INTEGERTYPE;
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDateType();
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator evaluator, IValue outputArg) throws XQERuntimeException {
        DateTimeValue end = (DateTimeValue)evaluator.getParameter(context, 0);
        DateTimeValue start = (DateTimeValue)evaluator.getParameter(context, 1);
        if (end.isNull() || start.isNull()) {
            outputArg.setNull();
        } else {
            int result = YMDIntBetween.calculateInterval(end, start, true);
            ((Value)outputArg).set(result);
        }
    }

    public static int calculateInterval(DateTimeValue end, DateTimeValue start, boolean abs) {
        int months = (end.getYear() - start.getYear()) * 12;
        int days = end.getDay() - start.getDay();
        GregorianCalendar t = new GregorianCalendar(end.getYear(), end.getMonth() - 1, end.getCalendar().getActualMinimum(5));
        if ((months += end.getMonth() - start.getMonth()) > 0 && days < 0) {
            --months;
            t.add(2, -1);
            days += t.getActualMaximum(5);
        } else if (months < 0 && days > 0) {
            ++months;
            days -= t.getActualMaximum(5);
        }
        int years = months / 12;
        int result = years * 10000 + (months %= 12) * 100 + days;
        if (abs && result < 0) {
            result = -result;
        }
        return result;
    }
}

