/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.json;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.json.JSONFunction;
import com.cognos.xqe.runtree.XDataContext;

public class JSONArray
extends JSONFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{45}, DataTypeCode.ALL_TYPES};

    public JSONArray() {
        super("JSONObject", ACCEPTED_TYPES, true, 1);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        Value output = (Value)outputArg;
        IValue[] values = pEvaluator.getParameters(context);
        boolean absentOnNull = !values[0].isNull() && values[0].toString().equals("ABSENT ON NULL");
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("[");
        for (int i = 1; i < values.length; ++i) {
            Value v = (Value)values[i];
            if (v.isNull() && absentOnNull) continue;
            if (i > 1) {
                sBuilder.append(", ");
            }
            sBuilder.append(v.getJSONLiteral());
        }
        sBuilder.append("]");
        output.set(sBuilder.toString());
    }
}

