/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.json;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.JSONValue;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.json.JSONFunction;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.json.JsonPathUtils;

public class JSONQuery
extends JSONFunction {
    private static final byte[][] ACCEPTED_TYPES = new byte[][]{{45}, {45}, {1, 107}};
    private static final int VAR_START = ACCEPTED_TYPES.length - 1;

    public JSONQuery() {
        super("JSONQuery", ACCEPTED_TYPES, true, VAR_START);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) {
        Object jsonObj;
        JSONValue output = (JSONValue)outputArg;
        IValue[] values = pEvaluator.getParameters(context);
        IValue content = values[0];
        IValue path = values[1];
        IValue errorOption = values[2];
        try {
            jsonObj = JsonPathUtils.read(content.toString(), path.toString());
        }
        catch (RuntimeException e) {
            if (!errorOption.isNull() && "ERROR ON ERROR".equalsIgnoreCase(errorOption.toString())) {
                throw e;
            }
            jsonObj = null;
        }
        if (jsonObj == null) {
            if (errorOption.isNull() || errorOption.toString().equalsIgnoreCase("EMPTY ON ERROR")) {
                output.set("{}");
                output.setState(ValueState.OK);
            } else {
                output.setNull();
            }
        } else {
            output.set(jsonObj);
        }
    }
}

