/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.numeric;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.NumericFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Asciiz
extends NumericFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{4, 6, 8, 10, 11, 12}, {6}, {6}};

    public Asciiz() {
        super("Asciiz", ACCEPTED_TYPES);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Asciiz.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getStringType();
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        int nArgs = pEvaluator.getParameterCount();
        Value input = (Value)pEvaluator.getParameter(context, 0);
        StringValue output = (StringValue)outputArg;
        boolean negNumber = false;
        if (input.isNull()) {
            output.setNull();
            return;
        }
        int reqLength = ((IntegerValue)pEvaluator.getParameter(context, 1)).getInteger();
        if (((NumericValue)input).sign() == -1) {
            --reqLength;
            ((NumericValue)input).negate();
            negNumber = true;
        }
        output.set(input.getString());
        int actLength = output.getString().length();
        int indexOfDecimal = output.getString().indexOf(46);
        int actScale = indexOfDecimal != -1 ? output.getString().length() - 1 - indexOfDecimal : 0;
        int integerPlace = output.getString().length() - actScale;
        int reqScale = nArgs > 2 ? ((IntegerValue)pEvaluator.getParameter(context, 2)).getInteger() : actScale;
        if (reqLength < reqScale) {
            reqScale = actScale;
        }
        if (actLength >= reqLength) {
            output.set(output.getString().substring(0, reqLength));
            indexOfDecimal = output.getString().indexOf(46);
            actScale = output.getString().length() - 1 - indexOfDecimal;
            integerPlace = output.getString().length() - actScale;
            if (actScale > reqScale) {
                output.set(output.getString().substring(0, integerPlace + reqScale));
                output.set(this.leftPad(output.getString(), '0', actScale - reqScale));
            }
        } else {
            if (actScale < reqScale) {
                if (actScale == 0) {
                    output.set(this.rightPad(output.getString(), '.', 1));
                }
                output.set(this.rightPad(output.getString(), '0', reqScale - actScale));
            } else if (actScale > reqScale) {
                output.set(input.getString());
                indexOfDecimal = output.getString().indexOf(46);
                output.set(output.getString().substring(0, indexOfDecimal + reqScale + 1));
            }
            actLength = output.getCurrentLength();
            if (actLength < reqLength) {
                output.set(this.leftPad(output.getString(), '0', reqLength - actLength));
            }
        }
        if (negNumber) {
            output.set("-".concat(output.getString()));
        }
    }

    private String leftPad(String aString, char padCharacter, int length) {
        char[] tmp = new char[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = padCharacter;
        }
        String result = String.copyValueOf(tmp).concat(aString);
        return result;
    }

    private String rightPad(String aString, char padCharacter, int length) {
        char[] tmp = new char[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = padCharacter;
        }
        String result = aString.concat(String.copyValueOf(tmp));
        return result;
    }
}

