/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.operator;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.values.IAddable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.BinaryNumericFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.character.Concat;
import com.cognos.xqe.runtree.XDataContext;

public class Add
extends BinaryNumericFunction {
    private static final String FUNCTION_NAME = "Add";
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{2, 4, 6, 8, 10, 11, 12, 17, 60, 59, 58, 57, 53, 52, 45, 107}, {2, 4, 6, 8, 10, 11, 12, 17, 60, 59, 58, 57, 53, 52, 45, 107}};
    private static final byte[][] RESULT_TYPES = new byte[][]{{4, 6, 8, 12, 10, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0}, {6, 6, 8, 12, 10, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0}, {8, 8, 8, 12, 10, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0}, {12, 12, 12, 12, 11, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0}, {10, 10, 10, 11, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0, 0}, {11, 11, 11, 11, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0, 0}, {12, 12, 12, 12, 11, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 17, 0, 59, 0, 57, 53, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 60, 59, 58, 57, 53, 52, 0}, {0, 0, 0, 0, 0, 0, 0, 59, 59, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 58, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 57, 57, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 53, 53, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45}};

    public Add() {
        super(FUNCTION_NAME, ACCEPTED_TYPES, RESULT_TYPES);
    }

    @Override
    protected IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Add.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        IDataType lDataType = oDataTypes[0];
        IDataType rDataType = oDataTypes[1];
        if (lDataType != null && (lDataType.isTextType() || lDataType.isClob()) || rDataType != null && (rDataType.isTextType() || rDataType.isClob())) {
            return Concat.getOutputType(oDataTypes);
        }
        if (lDataType == null || rDataType == null) {
            return null;
        }
        if (lDataType.isNullType() || rDataType.isNullType()) {
            return DataTypeFactory.getNullType();
        }
        if (lDataType.isFloatingPointDecimal() || rDataType.isFloatingPointDecimal()) {
            return DataTypeFactory.getDecimalType(0, 0);
        }
        IDataType result = null;
        int lDataTypeIndex = Add.getIndex(ACCEPTED_TYPES, lDataType, 0);
        int rDataTypeIndex = Add.getIndex(ACCEPTED_TYPES, rDataType, 1);
        byte cclDType = -1;
        if (lDataTypeIndex != -1 && rDataTypeIndex != -1) {
            cclDType = RESULT_TYPES[lDataTypeIndex][rDataTypeIndex];
        }
        if (cclDType == 57) {
            if (lDataType.getCCLTypeCode() == 57 && rDataType.getCCLTypeCode() == 60 && ((IntervalDayTimeType)rDataType).getQualifier() != IntervalQualifier.INTERVAL_DAY) {
                return null;
            }
            if (rDataType.getCCLTypeCode() == 57 && lDataType.getCCLTypeCode() == 60 && ((IntervalDayTimeType)lDataType).getQualifier() != IntervalQualifier.INTERVAL_DAY) {
                return null;
            }
        } else if (cclDType == 58) {
            IntervalQualifier qualifier;
            if (lDataType.getCCLTypeCode() == 60 && rDataType.getCCLTypeCode() == 58) {
                IDataType tmp = lDataType;
                lDataType = rDataType;
                rDataType = tmp;
            }
            if (lDataType.getCCLTypeCode() == 58 && rDataType.getCCLTypeCode() == 60 && ((qualifier = ((IntervalDayTimeType)rDataType).getQualifier()) == IntervalQualifier.INTERVAL_DAY || qualifier == IntervalQualifier.INTERVAL_DAY_TO_HOUR || qualifier == IntervalQualifier.INTERVAL_DAY_TO_MINUTE || qualifier == IntervalQualifier.INTERVAL_DAY_TO_SECOND)) {
                return null;
            }
        }
        if (cclDType != 0) {
            if (DataTypeCode.isInterval(cclDType)) {
                result = DataTypeComparator.getCompatibleType(lDataType, rDataType);
            } else if (DataTypeCode.isExactNumeric(cclDType)) {
                int precision = Add.getPrecision(lDataType, rDataType);
                int scale = Math.max(lDataType.getScale(), rDataType.getScale());
                result = DataTypeFactory.getDataType(cclDType, precision, scale);
            } else {
                result = DataTypeFactory.getDataType(cclDType);
            }
        }
        return result;
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        IAddable output = (IAddable)outputArg;
        Value input1 = (Value)pEvaluator.getParameter(context, 0);
        Value input2 = (Value)pEvaluator.getParameter(context, 1);
        if (input1.isNull() || input2.isNull()) {
            output.setNull();
        } else {
            output.set(input1);
            output.add(input2);
            Add.setFormatID((Value)outputArg, FUNCTION_NAME, input1, input2);
        }
    }
}

