/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.operator;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.BooleanFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.runtree.XDataContext;

public class Between
extends BooleanFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES};

    public Between() {
        super("Between", ACCEPTED_TYPES);
    }

    public boolean validArgumentTypesImpl(IDataType[] fArgumentTypes) {
        return DataTypeComparator.isComparableTo(fArgumentTypes[0], fArgumentTypes[1]) && DataTypeComparator.isComparableTo(fArgumentTypes[0], fArgumentTypes[2]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        BooleanValue output = (BooleanValue)outputArg;
        IValue input1 = pEvaluator.getParameter(context, 0);
        IValue input2 = pEvaluator.getParameter(context, 1);
        IValue input3 = pEvaluator.getParameter(context, 2);
        if (input1.isNull() || input2.isNull() || input3.isNull()) {
            output.setNull();
        } else {
            output.set(input1.compareTo(input2) >= 0 && input1.compareTo(input3) <= 0);
        }
    }
}

