/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.operator;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.values.IDivisible;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.BinaryNumericFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.runtree.XDataContext;

public class Divide
extends BinaryNumericFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{2, 4, 6, 8, 10, 11, 12, 17, 60, 107}, {2, 4, 6, 8, 10, 11, 12, 17, 60, 107}};
    private static final byte[][] RESULT_TYPES = new byte[][]{{11, 11, 11, 11, 11, 11, 12, 0, 0, 0, 0, 0, 0, 0}, {11, 11, 11, 11, 11, 11, 12, 0, 0, 0, 0, 0, 0, 0}, {11, 11, 11, 11, 11, 11, 12, 0, 0, 0, 0, 0, 0, 0}, {11, 11, 11, 11, 11, 11, 12, 0, 0, 0, 0, 0, 0, 0}, {11, 11, 11, 11, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0}, {11, 11, 11, 11, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0}, {12, 12, 12, 12, 10, 11, 12, 0, 0, 0, 0, 0, 0, 0}, {17, 17, 17, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {60, 60, 60, 60, 60, 60, 60, 0, 0, 0, 0, 0, 0, 0}};

    public Divide() {
        this("Divide");
    }

    protected Divide(String fName) {
        super(fName, ACCEPTED_TYPES, RESULT_TYPES);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        if (oDataTypes[0] == null || oDataTypes[1] == null) {
            return null;
        }
        if (oDataTypes[0].isNullType() || oDataTypes[1].isNullType()) {
            return DataTypeFactory.getNullType();
        }
        IDataType result = null;
        IDataType lDataType = oDataTypes[0];
        IDataType rDataType = oDataTypes[1];
        int lDataTypeIndex = Divide.getIndex(ACCEPTED_TYPES, lDataType, 0);
        int rDataTypeIndex = Divide.getIndex(ACCEPTED_TYPES, rDataType, 1);
        if (lDataTypeIndex == -1 || rDataTypeIndex == -1) {
            return null;
        }
        byte cclDType = RESULT_TYPES[Divide.getIndex(ACCEPTED_TYPES, lDataType, 0)][Divide.getIndex(ACCEPTED_TYPES, rDataType, 1)];
        if (cclDType != 0) {
            if (lDataType.isFloatingPointDecimal() || lDataType.isFloatingPointDecimal()) {
                result = DataTypeFactory.getDataType((byte)12, 0, 0);
            } else if (cclDType == 12) {
                int scale = lDataType.getScale() + rDataType.getPrecision();
                int precision = lDataType.getPrecision() - lDataType.getScale() + rDataType.getScale() + scale;
                scale = Math.min(scale, 128);
                precision = Math.min(precision, 256);
                result = DataTypeFactory.getDataType(cclDType, precision, scale);
            } else if (cclDType == 60) {
                IntervalDayTimeType oDataType = DataTypeFactory.getIntervalDayTimeType(IntervalQualifier.INTERVAL_DAY_TO_SECOND);
                if (lDataType.getCCLTypeCode() == 60 && rDataType.isNumeric() && oDataType.getQualifier() != ((IntervalType)lDataType).getQualifier()) {
                    oDataType.setQualifier(((IntervalType)lDataType).getQualifier());
                }
                result = oDataType;
            } else if (cclDType == 17) {
                IntervalYearMonthType oDataType = DataTypeFactory.getIntervalYearMonthType(IntervalQualifier.INTERVAL_YEAR_TO_MONTH);
                if (lDataType.getCCLTypeCode() == 17 && rDataType.isNumeric() && oDataType.getQualifier() != ((IntervalType)lDataType).getQualifier()) {
                    oDataType.setQualifier(((IntervalType)lDataType).getQualifier());
                }
                result = oDataType;
            } else {
                result = DataTypeFactory.getDataType(cclDType);
            }
        }
        return result;
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Divide.getOutputType(oDataTypes);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        IDivisible output = (IDivisible)outputArg;
        Value dividend = (Value)pEvaluator.getParameter(context, 0);
        Value divisor = (Value)pEvaluator.getParameter(context, 1);
        if (dividend.isNull() || divisor.isNull()) {
            output.setNull();
        } else {
            output.set(dividend);
            output.divide(divisor);
            Divide.setFormatID((Value)outputArg, "Divide", dividend, divisor);
        }
    }
}

