/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.regex;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.NumericFunction;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.adapters.dom.DOMAdapter;
import com.ibm.xml.xci.exec.BasicMutableDynamicContext;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PositionRegex
extends NumericFunction {
    public static final String FUNCTION_NAME = "PositionRegex";
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{1, 107}, DataTypeCode.ALL_TEXT_TYPES, DataTypeCode.ALL_TEXT_TYPES, {6, 8, 2, 4, 12, 10, 11, 107}, {6, 8, 2, 4, 12, 10, 11, 107}, DataTypeCode.ALL_TEXT_TYPES};
    public static final int START_OR_AFTER_IDX = 0;
    private static final int PATTERN_IDX = 1;
    private static final int INPUT_IDX = 2;
    private static final int FROM_IDX = 3;
    private static final int OCCURRENCE_IDX = 4;
    public static final int FLAG_IDX = 5;
    private static final String MATCH = "match";
    public static final String SCRIPT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:stylesheet version=\"2.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">  <xsl:output indent=\"yes\" method=\"xml\"/>  <xsl:param name=\"regex\" as=\"xs:string\"/>  <xsl:param name=\"flags\" as=\"xs:string\"/>  <xsl:template match=\"/\">    <xsl:analyze-string select=\"source\" regex=\"{$regex}\" flags=\"{$flags}\">      <xsl:matching-substring>        <match>          <xsl:value-of select=\".\"/>        </match>      </xsl:matching-substring>      <xsl:non-matching-substring>        <no-match>          <xsl:value-of select=\".\"/>        </no-match>      </xsl:non-matching-substring>    </xsl:analyze-string>  </xsl:template></xsl:stylesheet>";
    private static QName regex = new QName("regex");
    private static QName flags = new QName("flags");
    private SessionContext session = new SessionContext((ClassLoader)null);
    private CursorFactory factory = this.session.getSimpleDataFactory();
    private StaticContext staticCxt = new BasicStaticContext(this.session.getTypeRegistry());
    private Executable xsltExec;

    public PositionRegex() {
        super(FUNCTION_NAME, ACCEPTED_TYPES, false, 3);
        this.staticCxt.setLanguageTypeAndVersion(5);
        this.staticCxt.setBaseURI(System.getProperty("user.dir"));
        Preparer preparer = this.session.getPreparer(RequestInfo.XSLT2);
        this.xsltExec = preparer.prepare(SCRIPT, this.staticCxt, -1);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        Value output = (Value)outputArg;
        int nParameters = pEvaluator.getParameterCount();
        boolean startOrAfter = false;
        Value returnOpt = (Value)pEvaluator.getParameter(context, 0);
        if (!returnOpt.isNull() && returnOpt.getString().equals("AFTER")) {
            startOrAfter = true;
        }
        Value pattern = (Value)pEvaluator.getParameter(context, 1);
        Value input = (Value)pEvaluator.getParameter(context, 2);
        if (input.isNull() || pattern.isNull()) {
            output.setNull();
            return;
        }
        int fromPos = 1;
        int matchOcc = 1;
        String flagStr = "";
        if (nParameters > 3) {
            Value from = (Value)pEvaluator.getParameter(context, 3);
            if (from.isNull()) {
                output.setNull();
                return;
            }
            fromPos = from.getInteger();
        }
        if (nParameters > 4) {
            Value occurrence = (Value)pEvaluator.getParameter(context, 4);
            if (occurrence.isNull()) {
                output.setNull();
                return;
            }
            matchOcc = occurrence.getInteger();
        }
        if (nParameters > 5) {
            Value flag = (Value)pEvaluator.getParameter(context, 5);
            if (flag.isNull()) {
                output.setNull();
                return;
            }
            flagStr = flag.getString();
        }
        String source = input.getString();
        if (fromPos > 1) {
            source = source.substring(fromPos - 1);
        }
        source = String.format("<source>%s</source>", source);
        BasicMutableDynamicContext dynamicCxt = new BasicMutableDynamicContext(this.session, this.staticCxt);
        dynamicCxt.bindVariable(regex, this.factory.sequence((CharSequence)pattern.getString(), null, false));
        dynamicCxt.bindVariable(flags, this.factory.sequence((CharSequence)flagStr, null, false));
        RequestInfo request = new RequestInfo(Cursor.RANDOM_ACCESS, this.staticCxt);
        StreamSource document = new StreamSource(new StringReader(source));
        Cursor contextDoc = this.session.document((Source)document, request);
        DOMAdapter.DOMCursor result = (DOMAdapter.DOMCursor)this.xsltExec.execute(contextDoc, (DynamicContext)dynamicCxt, Cursor.RANDOM_ACCESS, null);
        if (result == null) {
            output.setNull();
            return;
        }
        NodeList nodeList = result.getNode().getChildNodes();
        int j = 0;
        int pos = 1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals(MATCH) && ++j == matchOcc) {
                if (!startOrAfter) break;
                pos += node.getTextContent().length();
                break;
            }
            pos += node.getTextContent().length();
        }
        if (j != matchOcc) {
            output.set(0);
        } else {
            output.set(pos);
        }
        result.release();
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return PositionRegex.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getIntegerType();
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][2]);
    }
}

