/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.ValueComparator;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;
import java.util.Arrays;

public class ArrayAgg
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES};

    public ArrayAgg() {
        super("ArrayAgg", "array_agg", ACCEPTED_TYPES, false, 1);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(this.getComparator());
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] ins) {
        return DataTypeFactory.getArrayType(ins[0]);
    }

    public static class State
    implements ISetFunctionState {
        private ArrayList<IValue> bag = new ArrayList();
        private int count = 0;
        private ValueComparator comparator;

        public State(ValueComparator vComparator) {
            this.comparator = vComparator;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            IValue input = pEvaluator.getParameter(context, 0);
            if (!input.isNull()) {
                this.bag.add((IValue)input.copy());
            }
            ++this.count;
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            IValue[] values = this.bag.toArray(new IValue[this.bag.size()]);
            if (this.comparator != null) {
                Arrays.sort(values, 0, this.count, this.comparator);
            }
            ((ArrayValue)value).set(values);
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

