/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IAddable;
import com.cognos.xqe.data.values.IDivisible;
import com.cognos.xqe.data.values.ISubtractable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.function.DistinctSetFunctionState;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.function.operator.Divide;
import com.cognos.xqe.function.set.SetFunctionsFormatManager;
import com.cognos.xqe.function.set.Sum;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;
import java.util.List;

public class Avg
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{2, 4, 6, 8, 10, 11, 12, 17, 60, 107}};

    public Avg() {
        super("Avg", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(context, type, this.isDistinct());
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Avg.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        if (oDataTypes[0] == null) {
            return DataTypeFactory.getDoubleType();
        }
        IDataType dType1 = Sum.getOutputType(oDataTypes);
        IntegerType dType2 = DataTypeFactory.getIntegerType();
        return Divide.getOutputType(new IDataType[]{dType1, dType2});
    }

    public static class AvgFormatManager
    extends SetFunctionsFormatManager {
        @Override
        protected FormatId calculateFormatId() {
            return AvgFormatManager.calculateFormatId(this.getInputFormatIdList());
        }

        public static FormatId calculateFormatId(List<FormatId> operandIds) {
            FormatService service = FormatService.getInstance();
            FormatId sumFormatId = service.formatResult("Sum", operandIds);
            ArrayList<FormatId> divideOperandIds = new ArrayList<FormatId>();
            divideOperandIds.add(sumFormatId);
            divideOperandIds.add(FormatId.EMPTY_FORMAT_FID);
            return service.formatResult("Divide", divideOperandIds);
        }
    }

    public static class State
    extends DistinctSetFunctionState {
        private Value sum;
        private int nonNullCount;
        private int nullCount = 0;
        private int count = 0;
        SetFunctionsFormatManager formatManager = new AvgFormatManager();

        public State() {
        }

        public State(XDataContext context, IDataType type, boolean isDistinct) {
            super(context, type, isDistinct);
            this.sum = (Value)type.createValue();
        }

        @Override
        protected void iterateImpl(XDataContext context, IValue input) {
            ++this.count;
            if (input.isNull()) {
                ++this.nullCount;
                return;
            }
            if (((Value)input).isDivByZero()) {
                this.sum.setState(ValueState.DIV_BY_ZERO);
            } else if (this.sum.isNull()) {
                this.sum.set(input);
            } else {
                ((IAddable)((Object)this.sum)).add(input);
            }
            ++this.nonNullCount;
            if (input instanceof Value) {
                this.formatManager.iterateFormat((Value)input);
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            Value input = (Value)pEvaluator.getParameter(context, 0);
            --this.count;
            if (input.isNull()) {
                --this.nullCount;
            }
            if (this.count == 0 || this.nullCount == this.count) {
                this.sum.set(0);
                this.nonNullCount = 0;
            } else if (!input.isNull()) {
                ((ISubtractable)((Object)this.sum)).subtract(input);
                --this.nonNullCount;
            }
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        protected void getResultImpl(XDataContext context, IValue output) {
            Value value = (Value)output;
            if (this.count == 0 || this.nullCount == this.count) {
                value.setNull();
            } else {
                value.set(this.sum);
                if (this.sum.isDivByZero()) {
                    value.setState(ValueState.DIV_BY_ZERO);
                } else if (this.sum instanceof NumericValue && this.sum.getDouble() != this.sum.getDouble()) {
                    value = DataValueFactory.createDoubleValue();
                    value.set(Double.NaN);
                } else {
                    ((IDivisible)((Object)value)).divide(DataValueFactory.convertObjectToIValue(this.nonNullCount));
                }
                value.setFormatId(this.formatManager.getResultFormat());
            }
        }
    }
}

