/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.function.DistinctSetFunctionState;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Count
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES};

    public Count() {
        super("Count", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(context, type, this.isDistinct());
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Count.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getLongType();
    }

    @Override
    public IDataType getResultDataType(IDataType[] oDataTypes) {
        return DataTypeFactory.getLongType();
    }

    public static class State
    extends DistinctSetFunctionState {
        private int count = 0;

        public State() {
        }

        public State(XDataContext context, IDataType type, boolean isDistinct) {
            super(context, type, isDistinct);
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterateImpl(XDataContext context, IValue input) {
            if (!input.isNull()) {
                ++this.count;
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            --this.count;
        }

        @Override
        protected void getResultImpl(XDataContext context, IValue value) {
            LongValue result = DataValueFactory.createLongValue();
            result.set(this.count);
            value.copyFrom(result);
        }
    }
}

