/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CumeDist
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[0][];

    public CumeDist() {
        super("CumeDist", "cume_dist", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State();
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return CumeDist.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getDoubleType();
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public boolean isTwoPass() {
        return true;
    }

    public static class State
    implements ISetFunctionState {
        private int count = 0;
        private ByteArrayOutputStream bo;
        private DataOutputStream output;
        private DataInputStream input;
        private Behaviour behaviour = new IterationBehaviour();

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            BooleanValue value = (BooleanValue)pEvaluator.getParameter(context, 0);
            ++this.count;
            this.behaviour.iterate(value);
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            this.behaviour.getResult((Value)value);
        }

        @Override
        public void terminate(XDataContext context) {
        }

        private class ResultBehaviour
        extends Behaviour {
            private int peerCount;
            private int cumeCount;

            ResultBehaviour() {
                State.this.input = new DataInputStream(new ByteArrayInputStream(State.this.bo.toByteArray()));
                State.this.output = null;
                State.this.bo = null;
                this.cumeCount = 0;
                this.peerCount = 0;
            }

            @Override
            public void iterate(BooleanValue theValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void getResult(Value value) {
                if (State.this.count <= 1) {
                    value.set(1.0);
                    return;
                }
                if (this.peerCount <= 0) {
                    try {
                        this.peerCount = State.this.input.readInt();
                    }
                    catch (IOException e) {
                        throw new XQERuntimeException(e);
                    }
                    this.cumeCount += this.peerCount;
                }
                double f = this.cumeCount;
                value.set(f /= (double)State.this.count);
                --this.peerCount;
            }
        }

        private class IterationBehaviour
        extends Behaviour {
            private int peerCount;

            IterationBehaviour() {
                State.this.bo = new ByteArrayOutputStream();
                State.this.output = new DataOutputStream(State.this.bo);
                this.peerCount = 0;
            }

            @Override
            public void iterate(BooleanValue theValue) {
                boolean changed = theValue.getBoolean();
                if (changed) {
                    try {
                        State.this.output.writeInt(this.peerCount);
                        this.peerCount = 0;
                    }
                    catch (IOException e) {
                        throw new XQERuntimeException(e);
                    }
                }
                ++this.peerCount;
            }

            @Override
            public void getResult(Value value) {
                if (State.this.output == null) {
                    throw new UnsupportedOperationException();
                }
                try {
                    State.this.output.writeInt(this.peerCount);
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
                State.this.behaviour = new ResultBehaviour();
                State.this.behaviour.getResult(value);
            }
        }

        private abstract class Behaviour {
            private Behaviour() {
            }

            public abstract void iterate(BooleanValue var1);

            public abstract void getResult(Value var1);
        }
    }
}

