/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Maximum
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES};

    public Maximum() {
        super("Maximum", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Maximum.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return oDataTypes[0];
    }

    public static class State
    implements ISetFunctionState {
        protected IValue maxValue = null;

        public State() {
        }

        public State(IDataType type) {
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            IValue input = pEvaluator.getParameter(context, 0);
            if (!(input.isNull() || this.maxValue != null && this.maxValue.compareTo(input) >= 0)) {
                this.maxValue = input;
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            if (this.maxValue != null) {
                value.copyFrom(this.maxValue);
            } else {
                value.setNull();
            }
        }

        @Override
        public void terminate(XDataContext context) {
        }

        @Override
        public long getCount() {
            return 0L;
        }
    }
}

