/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.DistinctSetFunctionState;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class RatioToReport
extends SetFunction {
    private static final long serialVersionUID = 1L;
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_NUMERIC_TYPES};

    public RatioToReport() {
        super("RatioToReport", "ratio_to_report", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State();
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return RatioToReport.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DoubleType.DOUBLETYPE;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public boolean isTwoPass() {
        return true;
    }

    public static class State
    extends DistinctSetFunctionState {
        private int count = 0;
        private ByteArrayOutputStream bo;
        private DataOutputStream output;
        private DataInputStream input;
        private double total;
        private Value inputValue;
        private Behaviour behaviour = new IterationBehaviour();

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterateImpl(XDataContext context, IValue value) {
            ++this.count;
            this.behaviour.iterate(context, (Value)value);
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getResultImpl(XDataContext context, IValue value) {
            this.behaviour.getResult(context, (Value)value);
        }

        public long getVersionID() {
            return 1L;
        }

        private class ResultBehaviour
        extends Behaviour {
            ResultBehaviour() {
                State.this.input = new DataInputStream(new ByteArrayInputStream(State.this.bo.toByteArray()));
                State.this.output = null;
                State.this.bo = null;
            }

            @Override
            public void iterate(XDataContext context, Value theValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void getResult(XDataContext context, Value value) {
                try {
                    State.this.inputValue.decode(context, State.this.input);
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
                if (State.this.inputValue.isNull()) {
                    value.setNull();
                } else {
                    double f = State.this.inputValue.getDouble();
                    value.set(f /= State.this.total);
                }
            }
        }

        private class IterationBehaviour
        extends Behaviour {
            IterationBehaviour() {
                State.this.bo = new ByteArrayOutputStream();
                State.this.output = new DataOutputStream(State.this.bo);
            }

            @Override
            public void iterate(XDataContext context, Value theValue) {
                if (State.this.inputValue == null) {
                    State.this.inputValue = (Value)theValue.getDataType().createValue(context.getLocalCollator());
                }
                try {
                    theValue.encode(context, State.this.output);
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
                if (!theValue.isNull()) {
                    double f = theValue.getDouble();
                    State.this.total = State.this.total + f;
                }
            }

            @Override
            public void getResult(XDataContext context, Value value) {
                State.this.behaviour = new ResultBehaviour();
                State.this.behaviour.getResult(context, value);
            }
        }

        private abstract class Behaviour {
            private Behaviour() {
            }

            public abstract void iterate(XDataContext var1, Value var2);

            public abstract void getResult(XDataContext var1, Value var2);
        }
    }
}

