/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.function.set.SetFunctionsFormatManager;
import com.cognos.xqe.function.set.VarPop;
import com.cognos.xqe.runtree.XDataContext;

public class StdDevPop
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_NUMERIC_TYPES};

    public StdDevPop() {
        super("StdDevPop", "stdev_pop", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return StdDevPop.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getDoubleType();
    }

    public static class StdDevPopFormatManager
    extends SetFunctionsFormatManager {
        @Override
        protected FormatId calculateFormatId() {
            FormatService service = FormatService.getInstance();
            return service.formatResult("StandardDeviation", this.getInputFormatIdList());
        }
    }

    public static class State
    extends VarPop.State {
        public State() {
        }

        public State(IDataType type) {
            super(type);
            this.formatManager = new StdDevPopFormatManager();
        }

        @Override
        public void getResult(XDataContext context, IValue iValue) {
            Value value = (Value)iValue;
            super.getResult(context, value);
            value.setFormatId(FormatId.INVALID_FORMAT_FID);
            if (!value.isNull()) {
                value.set(Math.sqrt(value.getDouble()));
                value.setFormatId(this.formatManager.getResultFormat());
            }
        }
    }
}

