/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.function.set.SetFunctionsFormatManager;
import com.cognos.xqe.function.set.VarSamp;
import com.cognos.xqe.runtree.XDataContext;

public class StdDevSamp
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_NUMERIC_TYPES};

    public StdDevSamp() {
        super("StdDevSamp", "stdev_samp", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return StdDevSamp.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getDoubleType();
    }

    public static class StdDevSampFormatManager
    extends SetFunctionsFormatManager {
        @Override
        protected FormatId calculateFormatId() {
            FormatService service = FormatService.getInstance();
            return service.formatResult("StandardDeviation", this.getInputFormatIdList());
        }
    }

    public static class State
    extends VarSamp.State {
        public State() {
        }

        public State(IDataType type) {
            super(type);
            this.formatManager = new StdDevSampFormatManager();
        }

        @Override
        public void getResult(XDataContext context, IValue iValue) {
            Value value = (Value)iValue;
            super.getResult(context, value);
            value.setFormatId(FormatId.INVALID_FORMAT_FID);
            if (!value.isNull()) {
                value.set(Math.sqrt(value.getDouble()));
                value.setFormatId(this.formatManager.getResultFormat());
            }
        }
    }
}

