/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set.regression;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.function.BinarySetFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class RegrAvgX
extends BinarySetFunction {
    public RegrAvgX() {
        super("RegrAvgX", "regr_avgx", true);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    protected static class State
    implements ISetFunctionState {
        private DoubleValue sumX;
        private int count;
        private int nullCount;
        private Set<FormatId> formatIds = new HashSet<FormatId>();

        public State() {
        }

        public State(IDataType type) {
            this.sumX = DataValueFactory.createDoubleValue();
            this.sumX.set(0);
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            NumericValue y = (NumericValue)pEvaluator.getParameter(context, 0);
            NumericValue x = (NumericValue)pEvaluator.getParameter(context, 1);
            ++this.count;
            if (y.isNull() || x.isNull()) {
                ++this.nullCount;
                return;
            }
            this.sumX.add(x);
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            NumericValue y = (NumericValue)pEvaluator.getParameter(context, 0);
            NumericValue x = (NumericValue)pEvaluator.getParameter(context, 1);
            --this.count;
            if (y.isNull() || x.isNull()) {
                --this.nullCount;
            }
            this.sumX.subtract(x);
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            int nonNullCount = this.count - this.nullCount;
            if (this.count == 0 || nonNullCount == 0) {
                value.setNull();
            } else {
                double d = this.sumX.getDouble() / (double)nonNullCount;
                DoubleValue doubleValue = DataValueFactory.createDoubleValue();
                doubleValue.set(d);
                FormatService service = FormatService.getInstance();
                FormatId sumFormatId = service.formatResult("Sum", new ArrayList<FormatId>(this.formatIds));
                ArrayList<FormatId> divideOperandIds = new ArrayList<FormatId>();
                divideOperandIds.add(sumFormatId);
                divideOperandIds.add(FormatId.EMPTY_FORMAT_FID);
                FormatId avgFormatId = service.formatResult("Divide", divideOperandIds);
                doubleValue.setFormatId(avgFormatId);
                value.copyFrom(doubleValue);
            }
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

