/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set.regression;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.function.BinarySetFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.runtree.XDataContext;

public class RegrSlope
extends BinarySetFunction {
    public RegrSlope() {
        super("RegrSlope", "regr_slope", true);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    protected static class State
    implements ISetFunctionState {
        protected DoubleValue sumX;
        protected DoubleValue sumX2;
        protected DoubleValue sumY;
        protected DoubleValue sumXY;
        protected int count;
        protected int nullCount;

        public State() {
        }

        public State(IDataType type) {
            this.sumX = DataValueFactory.createDoubleValue();
            this.sumX.set(0);
            this.sumX2 = DataValueFactory.createDoubleValue();
            this.sumX2.set(0);
            this.sumY = DataValueFactory.createDoubleValue();
            this.sumY.set(0);
            this.sumXY = DataValueFactory.createDoubleValue();
            this.sumXY.set(0);
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            NumericValue y = (NumericValue)pEvaluator.getParameter(context, 0);
            NumericValue x = (NumericValue)pEvaluator.getParameter(context, 1);
            ++this.count;
            if (y.isNull() || x.isNull()) {
                ++this.nullCount;
                return;
            }
            this.sumX.add(x);
            this.sumY.add(y);
            double d = this.sumXY.getDouble() + x.getDouble() * y.getDouble();
            this.sumXY.set(d);
            d = this.sumX2.getDouble() + x.getDouble() * x.getDouble();
            this.sumX2.set(d);
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            NumericValue y = (NumericValue)pEvaluator.getParameter(context, 0);
            NumericValue x = (NumericValue)pEvaluator.getParameter(context, 1);
            --this.count;
            if (y.isNull() || x.isNull()) {
                --this.nullCount;
            }
            this.sumX.subtract(x);
            this.sumY.subtract(y);
            double d = this.sumXY.getDouble() - x.getDouble() * y.getDouble();
            this.sumXY.set(d);
            d = this.sumX2.getDouble() - x.getDouble() * x.getDouble();
            this.sumX2.set(d);
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            NumericValue pValue = (NumericValue)value;
            int nonNullCount = this.count - this.nullCount;
            if (this.count == 0 || nonNullCount == 0) {
                pValue.setNull();
            } else {
                double d2;
                double d1 = this.sumX.getDouble() * this.sumX.getDouble();
                if (d1 == (d2 = (double)nonNullCount * this.sumX2.getDouble())) {
                    pValue.setNull();
                } else {
                    double result = (double)nonNullCount * this.sumXY.getDouble() - this.sumX.getDouble() * this.sumY.getDouble();
                    pValue.set(result /= d2 - d1);
                }
            }
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

