/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.udf;

import com.cognos.xqe.ast.sql.SQLTableFunction;
import com.cognos.xqe.ast.sql.ddl.SQLCreateFunction;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataLinkValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.ErrorList;
import com.cognos.xqe.function.IFunctionState;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.udf.UDTableFunction;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

public class UDJavaTableFunction
extends UDTableFunction
implements IFunctionState {
    static final long serialVersionUID = 539883639050706431L;
    private Method fMethod;
    private ErrorList errorList;

    public UDJavaTableFunction(String fName, IDataType[] udfArgumentTypes) {
        super(fName, udfArgumentTypes);
    }

    public UDJavaTableFunction(SQLCreateFunction ddlNode) {
        super(ddlNode);
    }

    public UDJavaTableFunction(SQLCreateFunction ddlNode, Method udfMethod, ErrorList udfErrorList) {
        this(ddlNode);
        this.fMethod = udfMethod;
        this.errorList = udfErrorList;
    }

    @Override
    public ITabularResultSet execute(XDataContext context, IParameterEvaluator pEvaluator, IRowsetInfo rowsetInfo) {
        return new TabularHybridResultSet(context, new UDTableFunctionResultSet(context, pEvaluator, rowsetInfo));
    }

    @Override
    public IDataType getResultDataType(SQLTableFunction function) {
        return this.resultType;
    }

    @Override
    public String getJarName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClassName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMethodName() {
        throw new UnsupportedOperationException();
    }

    public Method getMethod() {
        return this.fMethod;
    }

    @Override
    public boolean isUDFunction() {
        return true;
    }

    protected ResultSet invokeMethod(XDataContext context, IParameterEvaluator pEvaluator, Method fMethod) {
        Value pValue;
        ResultSet resultSet = null;
        int nArgs = pEvaluator.getParameterCount();
        Class<?>[] argClass = fMethod.getParameterTypes();
        int nParameters = this.getArgumentCount();
        Object[] args = new Object[nParameters];
        if (fMethod.isVarArgs()) {
            --nParameters;
        }
        for (int i = 0; i < nParameters; ++i) {
            pValue = (Value)pEvaluator.getParameter(context, i);
            args[i] = argClass[i].isInstance(pValue) ? pValue : this.getObject(argClass[i], pValue);
        }
        if (fMethod.isVarArgs()) {
            Class<?> clazz = argClass[nParameters].getComponentType();
            Object[] arr = (Object[])Array.newInstance(clazz, nArgs - nParameters);
            int k = 0;
            for (int j = nParameters; j < nArgs; ++j) {
                pValue = (Value)pEvaluator.getParameter(context, j);
                arr[k++] = super.getObject(clazz, pValue);
            }
            args[nParameters] = arr;
        }
        try {
            resultSet = (ResultSet)fMethod.invoke(null, args);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        return resultSet;
    }

    @Override
    public boolean isValid() {
        return this.errorList.isEmpty();
    }

    @Override
    public ErrorList getErrors() {
        return this.errorList;
    }

    private final class UDTableFunctionResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IParameterEvaluator pEvaluator;
        private ResultSet resultSet;
        private XVectorContext vContext;

        public UDTableFunctionResultSet(XDataContext context, IParameterEvaluator parameterEvaluator, IRowsetInfo theRowsetInfo) {
            super(context, context.getNodeId());
            this.pEvaluator = parameterEvaluator;
            this.vContext = ((IVectorContext)((Object)this.pEvaluator)).getVectorizationContext();
            try {
                this.resultSet = UDJavaTableFunction.this.invokeMethod(context, this.pEvaluator, UDJavaTableFunction.this.fMethod);
                if (theRowsetInfo.getNumColumns() == 0) {
                    ResultSetMetaData metadata = this.resultSet.getMetaData();
                    for (int i = 0; i < metadata.getColumnCount(); ++i) {
                        ColumnInfo columnInfo = new ColumnInfo(metadata.getColumnName(i + 1), DataTypeFactory.createDataTypeFromStandardJDBCType(metadata, i + 1));
                        theRowsetInfo.addColumnInfo(columnInfo);
                    }
                }
                this.setTabularRowsetInfo(theRowsetInfo);
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
        }

        @Override
        public IScrollableIterator getScrollableTabularIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new UDTableFunctionIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
        }

        private final class UDTableFunctionIterator
        extends XTabularIterator {
            private int nRows;
            private IRow result;
            private XVectorRowBatch batch;
            private int nColumns;
            private boolean eod;

            private UDTableFunctionIterator(XDataContext context) {
                super(context, context.getNodeId());
                this.startTimer();
                if (UDTableFunctionResultSet.this.resultSet == null) {
                    UDTableFunctionResultSet.this.resultSet = UDJavaTableFunction.this.invokeMethod(context, UDTableFunctionResultSet.this.pEvaluator, UDJavaTableFunction.this.fMethod);
                }
                this.nColumns = UDTableFunctionResultSet.this.rowsetInfo.getNumColumns();
                this.result = DataValueFactory.createRowValue(context.getLocalCollator(), UDTableFunctionResultSet.this.rowsetInfo);
                if (UDTableFunctionResultSet.this.vContext != null) {
                    this.batch = XVectorRowBatchUtil.createRowBatch(UDTableFunctionResultSet.this.vContext, UDTableFunctionResultSet.this.rowsetInfo, context.getLocalCollator());
                }
                this.stopTimer();
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                try {
                    if (!UDTableFunctionResultSet.this.resultSet.next()) {
                        return null;
                    }
                    ++this.nRows;
                    for (int i = 0; i < this.nColumns; ++i) {
                        Value value = (Value)this.result.getColumn(i);
                        switch (value.getDataType().getCCLTypeCode()) {
                            case 51: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getBoolean(i + 1));
                                break;
                            }
                            case 1: 
                            case 45: 
                            case 55: 
                            case 56: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getString(i + 1));
                                break;
                            }
                            case 4: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getShort(i + 1));
                                break;
                            }
                            case 6: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getInt(i + 1));
                                break;
                            }
                            case 8: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getLong(i + 1));
                                break;
                            }
                            case 10: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getFloat(i + 1));
                                break;
                            }
                            case 11: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getDouble(i + 1));
                                break;
                            }
                            case 12: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getBigDecimal(i + 1));
                                break;
                            }
                            case 57: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getDate(i + 1));
                                break;
                            }
                            case 58: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getTime(i + 1));
                                break;
                            }
                            case 59: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getTimestamp(i + 1));
                                break;
                            }
                            case 17: 
                            case 60: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getString(i + 1));
                                break;
                            }
                            case 52: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getString(i + 1));
                                break;
                            }
                            case 53: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getString(i + 1));
                                break;
                            }
                            case 23: 
                            case 24: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getBytes(i + 1));
                                break;
                            }
                            case 46: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getClob(i + 1));
                                break;
                            }
                            case 18: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getBlob(i + 1));
                                break;
                            }
                            case 100: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getString(i + 1));
                                break;
                            }
                            case 102: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getArray(i + 1));
                                break;
                            }
                            case 105: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getObject(i + 1));
                                break;
                            }
                            case 106: {
                                value.set(UDTableFunctionResultSet.this.resultSet.getObject(i + 1));
                                break;
                            }
                            case 48: {
                                ((DataLinkValue)value).set(UDTableFunctionResultSet.this.resultSet.getURL(i + 1));
                                break;
                            }
                        }
                        if (!UDTableFunctionResultSet.this.resultSet.wasNull()) continue;
                        value.setNull();
                    }
                }
                catch (Throwable e) {
                    throw new XQERuntimeException(e);
                }
                return this.result;
            }

            @Override
            public Object nextBatch() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                this.batch.reset();
                if (this.eod) {
                    this.batch.eod = true;
                    return this.batch;
                }
                try {
                    while (this.batch.size != this.batch.maxBatchSize && !this.eod) {
                        if (!UDTableFunctionResultSet.this.resultSet.next()) {
                            this.eod = true;
                        }
                        ++this.nRows;
                        for (int i = 0; i < this.nColumns; ++i) {
                            ColumnVector vector = this.batch.columns[i];
                            switch (UDTableFunctionResultSet.this.rowsetInfo.getColumnInfo(i).getDataType().getCCLTypeCode()) {
                                case 51: {
                                    vector.assign(this.batch.size, UDTableFunctionResultSet.this.resultSet.getBoolean(i + 1));
                                    break;
                                }
                                case 1: 
                                case 17: 
                                case 45: 
                                case 52: 
                                case 53: 
                                case 55: 
                                case 56: 
                                case 60: 
                                case 100: {
                                    vector.assign(this.batch.size, UDTableFunctionResultSet.this.resultSet.getString(i + 1));
                                    break;
                                }
                                case 4: {
                                    vector.assign(this.batch.size, UDTableFunctionResultSet.this.resultSet.getShort(i + 1));
                                    break;
                                }
                                case 6: {
                                    vector.assign(this.batch.size, UDTableFunctionResultSet.this.resultSet.getInt(i + 1));
                                    break;
                                }
                                case 8: {
                                    vector.assign(this.batch.size, UDTableFunctionResultSet.this.resultSet.getLong(i + 1));
                                    break;
                                }
                                case 10: {
                                    vector.assign(this.batch.size, Float.valueOf(UDTableFunctionResultSet.this.resultSet.getFloat(i + 1)));
                                    break;
                                }
                                case 11: {
                                    vector.assign(this.batch.size, UDTableFunctionResultSet.this.resultSet.getDouble(i + 1));
                                    break;
                                }
                                case 12: {
                                    vector.assign(this.batch.size, UDTableFunctionResultSet.this.resultSet.getBigDecimal(i + 1));
                                    break;
                                }
                                case 57: {
                                    vector.assign(this.batch.size, UDTableFunctionResultSet.this.resultSet.getDate(i + 1));
                                    break;
                                }
                                case 58: {
                                    vector.assign(this.batch.size, UDTableFunctionResultSet.this.resultSet.getTime(i + 1));
                                    break;
                                }
                                case 59: {
                                    vector.assign(this.batch.size, UDTableFunctionResultSet.this.resultSet.getTimestamp(i + 1));
                                    break;
                                }
                                case 23: 
                                case 24: {
                                    vector.assign(this.batch.size, UDTableFunctionResultSet.this.resultSet.getBytes(i + 1));
                                    break;
                                }
                                case 18: 
                                case 46: 
                                case 48: 
                                case 102: 
                                case 105: 
                                case 106: {
                                    throw new UnsupportedOperationException("Invalid data type.");
                                }
                            }
                            if (!UDTableFunctionResultSet.this.resultSet.wasNull()) continue;
                            vector.isNull[this.batch.size] = true;
                        }
                        ++this.batch.size;
                    }
                }
                catch (Throwable e) {
                    throw new XQERuntimeException(e);
                }
                return this.batch;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                try {
                    UDTableFunctionResultSet.this.resultSet.close();
                    UDTableFunctionResultSet.this.resultSet = null;
                }
                catch (Throwable e) {
                    throw new XQERuntimeException(e);
                }
            }
        }
    }
}

