/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.hooks;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.hooks.IHookEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class HookEnvironment
implements IHookEnvironment {
    private IExecutionEnvironment executionEnv;
    private IDataSource dataSource;
    private static XQELogger infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Hooks", LogLevel.INFO);
    private static XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Hooks", LogLevel.ERROR);

    public HookEnvironment(IExecutionEnvironment execEnv, IDataSource dSource) {
        this.executionEnv = execEnv;
        this.dataSource = dSource;
    }

    @Override
    public String getPackageName() {
        return this.executionEnv.getRequestEnvironment().getPackageName();
    }

    @Override
    public String getModelPath() {
        return this.executionEnv.getRequestEnvironment().getModelPath();
    }

    @Override
    public String getDataSourceName() {
        return this.dataSource.getName();
    }

    @Override
    public String getDataSourceConnectionName() {
        return this.dataSource.getDataSourceConnection().getName();
    }

    @Override
    public String getReportName() {
        return this.executionEnv.getRequestEnvironment().getReportName();
    }

    @Override
    public XQELogger getInfoLogger() {
        return infoLogger;
    }

    @Override
    public XQELogger getErrorLogger() {
        return errorLogger;
    }
}

