/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.xqe.ma4j.framework.MAConstraintProcessor;
import com.cognos.xqe.ma4j.framework.MAFunctionSupportUtility;
import com.cognos.xqe.ma4j.framework.MAQueryParser;
import com.cognos.xqe.ma4j.utilities.MADOMResponseBuilder;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.fds.IFunctionNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.dom4j.Branch;
import org.dom4j.Element;

public class MAFunctionResponseProcessor {
    static final String NAME = "name";
    static final String ID = "id";
    static final String UNKNOWN = "unknown";
    static final String FUNCTION = "function";
    MFWGateway mMFWGateway;
    MFWNodeHandle mProjNode;
    MAQueryParser mQueryParser;
    private MADOMResponseBuilder mIdDOMResponseBuilder = null;
    int mDepth = -1;
    MAConstraintProcessor mConstraintProcessor = null;
    ArrayList<String> mQueryTypeList = new ArrayList();
    ArrayList<String> mFunctionSetIDList = new ArrayList();
    ArrayList<String> mInterfacesList = new ArrayList();
    ArrayList<String> mVendorFunctionSetIDs = new ArrayList();
    ArrayList<String> mVendorFunctionSetNames = new ArrayList();

    public MAFunctionResponseProcessor(MFWGateway pGW, MFWNodeHandle hProjNode, MAConstraintProcessor constraintProcessor, MAQueryParser queryParser, MADOMResponseBuilder maDomBuilder) {
        this.mMFWGateway = pGW;
        this.mProjNode = hProjNode;
        this.mQueryParser = queryParser;
        this.mIdDOMResponseBuilder = maDomBuilder;
        this.mConstraintProcessor = constraintProcessor;
    }

    public void getFunctionSetResponse(Element originalResponse) {
    }

    public void getFunctionResponse(Element originalResponse) {
        Set<String> propColl = this.mQueryParser.getMetadataParameters().getCollections();
        if (propColl == null) {
            return;
        }
        if (propColl.contains("functionSet")) {
            Element functionsRoot = this.mIdDOMResponseBuilder.createElement((Branch)originalResponse, "functionsRoot");
            Element parentElem = this.mIdDOMResponseBuilder.createElement((Branch)functionsRoot, "functionSets");
            this.getFunctionSetInfo();
            for (int i = 0; i < this.mVendorFunctionSetIDs.size(); ++i) {
                Element currentElem = this.mIdDOMResponseBuilder.createElement((Branch)parentElem, "functionSet");
                Element childElem = this.mIdDOMResponseBuilder.createElement((Branch)currentElem, "functionSetID");
                String theFuncSetId = this.mVendorFunctionSetIDs.get(i);
                this.mIdDOMResponseBuilder.createTextNode(childElem, theFuncSetId);
                String theFuncSetName = this.mVendorFunctionSetNames.get(i);
                childElem = this.mIdDOMResponseBuilder.createElement((Branch)currentElem, "functionSetName");
                this.mIdDOMResponseBuilder.createTextNode(childElem, theFuncSetName);
            }
            return;
        }
        IFunctionNode fNode = this.buildFunctionInfo();
        String type = this.getObjectType(fNode);
        Element functionsRoot = this.mIdDOMResponseBuilder.createElement((Branch)originalResponse, "functionsRoot");
        Element parentElem = this.mIdDOMResponseBuilder.createElement((Branch)functionsRoot, type);
        if (!this.getPropertyValues(parentElem, fNode)) {
            return;
        }
        MaStackFunctionElement stackFunctionElement = new MaStackFunctionElement(fNode, parentElem);
        Stack<MaStackFunctionElement> stack = new Stack<MaStackFunctionElement>();
        int depthLevel = 1;
        stack.push(stackFunctionElement);
        while (stack.size() > 0) {
            ArrayList<IFunctionNode> children;
            MaStackFunctionElement stackNode = (MaStackFunctionElement)stack.peek();
            stack.pop();
            IFunctionNode funNode = stackNode.getFunctionNode();
            Element currentParent = stackNode.getXMLElement();
            if (this.mDepth != -1 && depthLevel >= this.mDepth || (children = funNode.getChildren()) == null) continue;
            for (int i = 0; i < children.size(); ++i) {
                IFunctionNode theFuncNode = children.get(i);
                type = this.getObjectType(theFuncNode);
                Element currentElem = this.mIdDOMResponseBuilder.createElement((Branch)currentParent, type);
                stack.push(new MaStackFunctionElement(theFuncNode, currentElem));
                this.getPropertyValues(currentElem, theFuncNode);
                ++depthLevel;
            }
        }
    }

    private void getFunctionSetInfo() {
        MFWNodeHandle[] namespaces = this.mMFWGateway.getObjectChildren(this.mProjNode, MFWModelRes.getInstance().RID_namespace);
        Locale authLocale = LocaleConverter.strToLocale(this.mQueryParser.getAuthoringLocale());
        MAFunctionSupportUtility pFunctionSupport = new MAFunctionSupportUtility(this.mMFWGateway, this.mQueryParser, namespaces[0], authLocale);
        pFunctionSupport.getSupportedFunctionSetInfo(this.mVendorFunctionSetIDs, this.mVendorFunctionSetNames);
    }

    private IFunctionNode buildFunctionInfo() {
        MFWNodeHandle namespace = null;
        if (this.mMFWGateway != null) {
            this.readFunctionSetIDsFromModel();
            MFWNodeHandle[] namespaces = this.mMFWGateway.getObjectChildren(this.mProjNode, MFWModelRes.getInstance().RID_namespace);
            namespace = namespaces[0];
        }
        Locale authLocale = LocaleConverter.strToLocale(this.mQueryParser.getAuthoringLocale());
        MAFunctionSupportUtility pFunctionSupport = new MAFunctionSupportUtility(this.mMFWGateway, this.mQueryParser, namespace, authLocale);
        IFunctionNode funNode = null;
        String startAtPath = this.mQueryParser.getStartAtPath();
        String sDepth = this.mQueryParser.getValueForAttribute("Depth");
        if (sDepth != null && sDepth.length() > 0) {
            this.mDepth = Integer.valueOf(sDepth);
        }
        funNode = pFunctionSupport.buildFunctionInfoNode(startAtPath, this.mDepth, this.mConstraintProcessor, this.mQueryTypeList, this.mFunctionSetIDList, this.mInterfacesList);
        return funNode;
    }

    private String getObjectType(IFunctionNode node) {
        String objectType = null;
        if (node == null) {
            return objectType;
        }
        objectType = node.isGroup() ? "group" : FUNCTION;
        return objectType;
    }

    private boolean getPropertyValues(Element elem, IFunctionNode node) {
        String type = this.getObjectType(node);
        Set<String> propColl = this.mQueryParser.getMetadataParameters().getRestrictedProperties().get(type);
        if (propColl == null) {
            return false;
        }
        TreeSet<String> sortedSet = new TreeSet<String>(propColl);
        ArrayList<String> attributeValues = new ArrayList<String>();
        for (String attribute : sortedSet) {
            if (attribute.length() == 0) {
                attribute = NAME;
            }
            boolean valueFound = false;
            if (attribute.equals(NAME)) {
                attributeValues.add(node.getName());
                valueFound = true;
            } else if (attribute.equals("functionId")) {
                attributeValues.add(node.getId());
                valueFound = true;
            } else if (attribute.equals(ID) && node.isGroup()) {
                attributeValues.add(node.getId());
                valueFound = true;
            } else if (attribute.equals(ID)) {
                attributeValues.add(node.getId());
                valueFound = true;
            } else if (attribute.equals("formatType")) {
                attributeValues.add(node.getFormatType());
                valueFound = true;
            } else if (attribute.equals("qosLevel")) {
                String value = UNKNOWN;
                IFunctionNode.FDSQoSLevelEnum level = node.getQoSLevel();
                switch (level) {
                    case UNAVAILABLE: {
                        value = "unavailable";
                        break;
                    }
                    case RESTRICTED: {
                        value = "restricted";
                        break;
                    }
                    case LIMITED: {
                        value = "limited";
                        break;
                    }
                    case OK: {
                        value = "OK";
                        break;
                    }
                    default: {
                        value = UNKNOWN;
                    }
                }
                attributeValues.add(value);
                valueFound = true;
            } else if (attribute.equals("tip")) {
                this.addPropertyAsElement(elem, attribute, node.getTip());
            } else if (attribute.equals("syntax")) {
                this.addPropertyAsElement(elem, attribute, node.getSyntax());
            } else if (attribute.contains("result") || attribute.contains("resultdata") || attribute.contains("example")) {
                this.addPropertyAsElement(elem, attribute, node.getProperty(attribute));
            } else {
                String val = node.getProperty(attribute);
                attributeValues.add(val);
                valueFound = true;
            }
            if (!valueFound) continue;
            Iterator attrIter = attributeValues.iterator();
            while (attrIter.hasNext()) {
                this.mIdDOMResponseBuilder.addAttribute(elem, attribute, (String)attrIter.next());
            }
        }
        return true;
    }

    private void addPropertyAsElement(Element elem, String propName, String propValue) {
        if (propValue != null && !propValue.isEmpty()) {
            Element elemAttrName = this.mIdDOMResponseBuilder.createElement((Branch)elem, propName);
            this.mIdDOMResponseBuilder.createTextNode(elemAttrName, propValue);
        }
    }

    private void readFunctionSetIDsFromModel() {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeHandle[] datasourceCollection = this.mMFWGateway.getObjectChildren(this.mProjNode, gModelRes.RID_dataSource);
        for (int i = 0; i < datasourceCollection.length; ++i) {
            MFWNodeHandle theDatasource = datasourceCollection[i];
            String theQueryType = this.mMFWGateway.getObjectPropertyValue(theDatasource, gModelRes.RID_queryType);
            this.mQueryTypeList.add(theQueryType);
            String theInterfaceProp = this.mMFWGateway.getObjectPropertyValue(theDatasource, gModelRes.RID_interface);
            if (theInterfaceProp == null) continue;
            this.mInterfacesList.add(theInterfaceProp);
        }
        MFWNodeHandle[] securityViewsCollection = null;
        MFWNodeHandle[] vSecutyViewCollectors = this.mMFWGateway.getObjectChildren(this.mProjNode, gModelRes.RID_securityViews);
        if (vSecutyViewCollectors != null && vSecutyViewCollectors.length > 0) {
            securityViewsCollection = this.mMFWGateway.getObjectChildren(vSecutyViewCollectors[0], gModelRes.RID_securityView);
        }
        if (securityViewsCollection != null && securityViewsCollection.length > 0) {
            void securityView = securityViewsCollection[0];
            MFWNodeHandle[] functionSetCollection = this.mMFWGateway.getObjectChildren((MFWNodeHandle)securityView, gModelRes.RID_functionSet);
            for (int j = 0; j < functionSetCollection.length; ++j) {
                String thefunctionSetId = this.mMFWGateway.getObjectPropertyValue(functionSetCollection[j], gModelRes.RID_functionSetID);
                this.mFunctionSetIDList.add(thefunctionSetId);
            }
        }
    }

    class MaStackFunctionElement {
        private IFunctionNode node;
        private Element element;

        MaStackFunctionElement(IFunctionNode fNode, Element fTypeElem) {
            this.node = fNode;
            this.element = fTypeElem;
        }

        Element getXMLElement() {
            return this.element;
        }

        IFunctionNode getFunctionNode() {
            return this.node;
        }
    }
}

