/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.ma4j.framework.MAGateway;
import com.cognos.xqe.ma4j.framework.MAQueryExecutor;
import com.cognos.xqe.ma4j.framework.MAQueryInfo;
import com.cognos.xqe.ma4j.framework.MAQueryParser;
import com.cognos.xqe.runtree.ma.MAXNodeRuntimeException;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import com.cognos.xqe.util.xml.XMLUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MAGatewayImpl
extends MAGateway {
    private static boolean mSystemInitialized = false;
    private MFWGateway mPGW = null;
    private MAQueryParser mQueryParser = null;
    private MAQueryExecutor mQueryExecutor = null;
    private DocumentBuilder mBuilder = null;
    private Document mDocument = null;

    public MAGatewayImpl() {
        MAGatewayImpl.initializeSystem();
    }

    @Override
    public void closeModel() {
        this.closeGateway();
        this.releaseDom();
        this.initialize();
    }

    @Override
    public boolean executeQuery() {
        if (this.mPGW != null) {
            this.mQueryExecutor = new MAQueryExecutor(this.mPGW, this.mQueryParser, null);
            return this.mQueryExecutor.executeQuery();
        }
        return false;
    }

    @Override
    public String getResponseXML() {
        if (this.mQueryExecutor != null) {
            return this.mQueryExecutor.getResponseDOMXML();
        }
        return null;
    }

    @Override
    public Document getResponseDOM() {
        if (this.mQueryExecutor != null) {
            return this.mQueryExecutor.getResponseDOM();
        }
        return null;
    }

    @Override
    public boolean openModel(String queryFileName) {
        this.initialize();
        this.mQueryParser.processClientRequest(this.parseXmlFile(queryFileName));
        this.openModel();
        return true;
    }

    @Override
    public boolean openModel(Element rootClientRequest) {
        this.initialize();
        this.mQueryParser.processClientRequest(rootClientRequest);
        this.openModel();
        return true;
    }

    @Override
    public MAQueryInfo getqueryInfo() {
        if (this.mQueryParser != null) {
            return this.mQueryParser.getQueryInfo();
        }
        return null;
    }

    private void initialize() {
        this.mPGW = null;
        this.mQueryParser = new MAQueryParser();
        this.setMBuilder(null);
        this.setMDocument(null);
        this.mQueryExecutor = null;
    }

    private void openModel() {
        String connectionType = "cmSearchPath";
        String connectionString = this.mQueryParser.getDataSource();
        String updatedConnectionString = null;
        String packagePath = null;
        if (connectionString.length() > 0) {
            if (connectionString.indexOf("@") == -1) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("/content/package[@name=");
                buffer.append(XMLUtils.xPathLiteral(connectionString));
                buffer.append("]");
                packagePath = buffer.toString();
                buffer.append("/model[last()]");
                updatedConnectionString = buffer.toString();
            } else {
                updatedConnectionString = connectionString;
            }
        }
        this.mQueryParser.setDataSource(packagePath);
        this.mQueryParser.setModelSearchPath(updatedConnectionString);
        String productlocale = this.mQueryParser.getProductLocale();
        String contentlocale = this.mQueryParser.getRunLocale();
        String passport = this.mQueryParser.getCAMPassport();
        if (passport == null) {
            passport = new String();
        }
        if ("".equals(passport)) {
            MFWContentHelper helper = MFWContentHelper.create((String)contentlocale, (String)productlocale);
            passport = helper.authenticateUser("", "", "");
            this.mQueryParser.setCAMPassport(passport);
        }
        this.openGateway(connectionType, updatedConnectionString, productlocale, contentlocale, passport);
        this.mQueryParser.calcEffectiveAuthoringLocales(this.mPGW);
    }

    private void openGateway(String connectionType, String connectionString, String productlocale, String contentlocale, String passport) {
        MFWMetadataSource aSource = MFWMetadataSource.create((String)"modelFM");
        aSource.addConnectionItem(connectionType, (Object)connectionString);
        MFWRequestContext aContext = MFWRequestContext.create((String)productlocale, (String)contentlocale, (String)passport);
        String sGID = "GID";
        aContext.setAdvancedIDResolution(true);
        this.mPGW = MFWGateway.open((String)sGID, (MFWRequestContext)aContext, (MFWMetadataSource)aSource);
    }

    private void closeGateway() {
        if (this.mPGW != null) {
            this.mPGW.close();
        }
    }

    private Element parseXmlFile(String queryFileName) {
        MAXNodeRuntimeException exception;
        Document rootNode;
        block10: {
            SAXReader aReader;
            XQESAXReaderPool readerPool;
            block9: {
                rootNode = null;
                readerPool = XQESAXReaderPool.getInstance();
                aReader = null;
                BufferedInputStream fileInputStream = null;
                exception = null;
                try {
                    aReader = readerPool.borrowReader();
                    fileInputStream = new BufferedInputStream(new FileInputStream(queryFileName));
                    rootNode = aReader.read((InputStream)fileInputStream);
                }
                catch (Exception e) {
                    exception = new MAXNodeRuntimeException(XQEMessageKeys.MA_QueryFileNotFound, (Throwable)e, queryFileName);
                }
                try {
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                }
                catch (Exception e) {
                    if (exception != null) break block9;
                    exception = new MAXNodeRuntimeException(XQEMessageKeys.MA_QueryFileNotFound, (Throwable)e, queryFileName);
                }
            }
            try {
                if (aReader != null) {
                    readerPool.returnReader(aReader);
                }
            }
            catch (Exception e) {
                if (exception != null) break block10;
                exception = new MAXNodeRuntimeException(XQEMessageKeys.MA_QueryFileNotFound, (Throwable)e, queryFileName);
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.setMDocument(rootNode);
        return rootNode.getRootElement();
    }

    private void releaseDom() {
        this.setMDocument(null);
        this.setMBuilder(null);
    }

    private static void initializeSystem() {
        if (!mSystemInitialized) {
            MAGatewayImpl.initRequiredComponents();
            mSystemInitialized = true;
        }
    }

    private static void initRequiredComponents() {
        ICCLConfiguration configuration = XQECCLConfigurationFactory.getInstance();
        try {
            configuration.init();
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    public void setMBuilder(DocumentBuilder builder) {
        this.mBuilder = builder;
    }

    public DocumentBuilder getMBuilder() {
        return this.mBuilder;
    }

    public void setMDocument(Document document) {
        this.mDocument = document;
    }

    public Document getMDocument() {
        return this.mDocument;
    }
}

