/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.i18n.NumericFormat;
import com.cognos.i18n.ToolkitResources;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.ma4j.framework.MAObjectBrowser;
import com.cognos.xqe.ma4j.framework.MAWorkingLocales;
import com.cognos.xqe.util.LocaleConverter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MAGlobalsProcessor
extends MAObjectBrowser {
    private static Map<Locale, String> separators = new ConcurrentHashMap<Locale, String>();
    String mListSeparator;
    String mDefaultLocale;
    Set<String> mSupportedLocales = null;
    String mEffectiveExpressionLocale;
    String mEffectiveContentLocale;
    private static ICCLConfiguration gCCLCONFIG = null;

    public MAGlobalsProcessor(MFWGateway pGW, MAWorkingLocales locales) {
        super(pGW, locales);
    }

    public void getModelLocales() {
        this.mDefaultLocale = this.getMFWGateway().getObjectPropertyValue(this.getProjectNode(), MAGlobalsProcessor.MODEL_RES.RID_defaultLocale);
        this.mSupportedLocales = this.queryModelLocales(this.getProjectNode());
    }

    private Set<String> queryModelLocales(MFWNodeHandle projHandle) {
        MFWNodeHandle[] hLocaleProps = this.getMFWGateway().getObjectChildren(projHandle, MAGlobalsProcessor.MODEL_RES.RID_locale);
        HashSet<String> outLocales = new HashSet<String>(hLocaleProps.length);
        for (int idx = 0; idx < hLocaleProps.length; ++idx) {
            outLocales.add(this.getMFWGateway().getPropertyValue(hLocaleProps[idx]));
        }
        return outLocales;
    }

    public String getListSeparator(Locale locale) {
        if (this.mListSeparator != null) {
            return this.mListSeparator;
        }
        this.mListSeparator = locale == null ? "," : ToolkitResources.getListSeparator((Locale)locale);
        return this.mListSeparator;
    }

    public String getDecimalSeparator(Locale locale) {
        String separator = separators.get(locale);
        if (separator == null) {
            NumericFormat fmt = new NumericFormat(9, locale);
            char decimalSep = fmt.getDecimalSeparator();
            separator = new Character(decimalSep).toString();
            separators.put(locale, separator);
        }
        return separator;
    }

    public String getDefaultLocale() {
        if (this.mDefaultLocale == null) {
            this.getModelLocales();
        }
        return this.mDefaultLocale;
    }

    public Set<String> getSupportedLocales() {
        if (this.mSupportedLocales == null) {
            this.mSupportedLocales = new HashSet<String>();
            this.getModelLocales();
        }
        return this.mSupportedLocales;
    }

    public String getEffectiveContentLocale(Locale locale) {
        if (this.mEffectiveContentLocale == null) {
            this.mEffectiveContentLocale = this.validateLocale(LocaleConverter.toString(locale), this.getSupportedLocales(), this.getDefaultLocale());
        }
        return this.mEffectiveContentLocale;
    }

    public String getEffectiveExpressionLocale(Locale locale) throws CCLConfigurationException {
        if (this.mEffectiveExpressionLocale == null) {
            this.mEffectiveExpressionLocale = this.validateLocale(LocaleConverter.toString(locale), this.getSupportedLocales(), this.getDefaultLocale());
        }
        return this.mEffectiveExpressionLocale;
    }

    public String validateLocale(String locale, Set<String> supportedLocales, String defaultLocale) {
        try {
            String validatedLocale = locale;
            String normalizedLocale = gCCLCONFIG.normalizeLocale(locale);
            boolean isValid = gCCLCONFIG.validateContentLocale(normalizedLocale);
            if (isValid) {
                String tmpNormalizedLocale = null;
                Iterator<String> suppIter = supportedLocales.iterator();
                while (suppIter.hasNext()) {
                    tmpNormalizedLocale = gCCLCONFIG.normalizeLocale(suppIter.next());
                    if (normalizedLocale.compareTo(tmpNormalizedLocale) != 0) continue;
                    validatedLocale = normalizedLocale;
                    return validatedLocale;
                }
                try {
                    validatedLocale = gCCLCONFIG.mapContentLocale(normalizedLocale, false);
                }
                catch (CCLConfigurationException e) {
                    validatedLocale = gCCLCONFIG.normalizeLocale(defaultLocale);
                    mErrorLogger.log(e);
                    return validatedLocale;
                }
                if (supportedLocales.contains(validatedLocale)) {
                    return validatedLocale;
                }
                for (String aLocale : supportedLocales) {
                    if (validatedLocale != gCCLCONFIG.mapContentLocale(aLocale, false)) continue;
                    validatedLocale = aLocale;
                    return validatedLocale;
                }
            }
            validatedLocale = gCCLCONFIG.normalizeLocale(defaultLocale);
            if (defaultLocale.length() == 0) {
                return validatedLocale;
            }
            return validatedLocale;
        }
        catch (CCLConfigurationException e) {
            throw new XQERuntimeException(e);
        }
    }

    static {
        try {
            gCCLCONFIG = XQECCLConfigurationFactory.getInstance();
            if (gCCLCONFIG == null) {
                gCCLCONFIG = XQECCLConfigurationFactory.createConfiguration();
                gCCLCONFIG.init();
            }
        }
        catch (CCLConfigurationException e) {
            throw new XQERuntimeException(e);
        }
    }
}

