/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.xqe.ma4j.framework.MAGlobalsProcessor;
import com.cognos.xqe.ma4j.framework.MAObjectBrowser;
import com.cognos.xqe.ma4j.framework.MAWorkingLocales;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Locale;

public class MAIDManager
extends MAObjectBrowser {
    private StringBuilder mRefID = new StringBuilder();
    private StringBuilder mPathID = new StringBuilder();
    private short mLastRefType = (short)-1;
    private short mLastOrigRefType = (short)-1;
    private MFWNodeHandle mLastHandle = null;
    private static final short RID_QUERYSUBJECT = MFWModelRes.getInstance().RID_querySubject;
    private static final short RID_FOLDER = MFWModelRes.getInstance().RID_folder;
    private static final short RID_QUERYITEMFOLDER = MFWModelRes.getInstance().RID_queryItemFolder;
    private static final short RID_HIERARCHYFOLDER = MFWModelRes.getInstance().RID_hierarchyFolder;
    private static final short RID_MEASUREFOLDER = MFWModelRes.getInstance().RID_measureFolder;
    private static final short RID_NAMESPACE = MFWModelRes.getInstance().RID_namespace;
    private static final short RID_PROJECT = MFWModelRes.getInstance().RID_project;
    private static final short RID_ROLE = MFWModelRes.getInstance().RID_role;
    private static final short RID_SHORTCUT = MFWModelRes.getInstance().RID_shortcut;

    public MAIDManager(MFWGateway pGW, MAWorkingLocales locales) {
        super(pGW, locales);
        this.mLastRefType = (short)-1;
        this.mLastOrigRefType = (short)-1;
    }

    public boolean hasValidIDFormat(String crnID) {
        return (crnID = crnID.trim()).length() > 2 && crnID.startsWith("[") && crnID.endsWith("]");
    }

    public ArrayList<String> splitID(String sID) {
        ArrayList<String> ids = new ArrayList<String>();
        String[] tokens = sID.split("\\]\\.");
        for (int k = 0; k < tokens.length; ++k) {
            String separator = "";
            if (k < tokens.length - 1) {
                separator = "]";
            }
            String token = tokens[k] + separator;
            token = token.trim();
            ids.add(token);
        }
        return ids;
    }

    public String getRefID() {
        return this.mRefID.toString();
    }

    public String getPathID() {
        return this.mPathID.toString();
    }

    public void clearRefID() {
        int length = this.mRefID.length();
        if (length > 0) {
            this.mRefID.delete(0, length);
        }
        this.mLastRefType = (short)-1;
        this.mLastOrigRefType = (short)-1;
        this.mLastHandle = null;
    }

    public void clearPathID() {
        int length = this.mPathID.length();
        if (length > 0) {
            this.mPathID.delete(0, length);
        }
    }

    public void initializeRefID(String id, short lastOrigRefType, short lastRefType, MFWNodeHandle lastHandle) {
        this.clearRefID();
        this.mRefID.append(id);
        this.mLastRefType = lastRefType;
        this.mLastOrigRefType = lastOrigRefType;
        this.mLastHandle = lastHandle;
    }

    public void initializePathID(String id) {
        this.clearPathID();
        this.mPathID.append(id);
    }

    public void buildRefID(String name, short originalType, short targetType, MFWNodeHandle handle) {
        boolean skipFolder = false;
        if (this.mLastOrigRefType == RID_SHORTCUT && this.mLastRefType == RID_FOLDER) {
            for (MFWNodeHandle h = handle; h != null; h = h.getParent()) {
                if (h.getNameRID() != RID_NAMESPACE) continue;
                String namespace = this.buildRefPath(h);
                this.mRefID = new StringBuilder(namespace);
                break;
            }
        }
        if (this.isFolderType(targetType)) {
            skipFolder = true;
            MFWNodeObject current = (MFWNodeObject)handle;
            MFWNodeObject parent = (MFWNodeObject)handle.getParent();
            if (parent.getNameRID() == RID_QUERYITEMFOLDER || parent.getNameRID() == RID_QUERYSUBJECT) {
                String currentDataType = current.getPropertyValue(MFWModelRes.getInstance().RID_datatype);
                String parentDataType = parent.getPropertyValue(MFWModelRes.getInstance().RID_datatype);
                if (parentDataType != null || parent.getNameRID() == RID_QUERYSUBJECT && currentDataType != null) {
                    skipFolder = false;
                }
            }
        }
        if (targetType == RID_NAMESPACE) {
            int length = this.mRefID.length();
            this.mRefID.delete(0, length);
            this.mLastRefType = (short)-1;
            this.mLastHandle = null;
        }
        if (name != null && !skipFolder) {
            if (this.mRefID.length() > 0) {
                this.mRefID.append(".");
            }
            this.mRefID.append(UniqueNameGenerator.createUniqueName(name));
        }
        if (targetType == RID_ROLE) {
            this.restoreRoleRef(handle, name);
        }
        this.mLastRefType = targetType;
        this.mLastOrigRefType = originalType;
        this.mLastHandle = handle;
    }

    public void restoreRoleRef(MFWNodeHandle handle, String name) {
        String twoBrackets = "].[";
        int index = this.mRefID.lastIndexOf(twoBrackets, this.mRefID.lastIndexOf(twoBrackets) - 1);
        String substr = null;
        if (index != -1) {
            substr = this.mRefID.substring(0, index + 1);
        }
        StringBuilder updatedReference = new StringBuilder(substr);
        String handleType = null;
        MFWNodeHandle parentHandle = handle.getParent();
        if (parentHandle != null) {
            handleType = parentHandle.getName();
        }
        if (handleType.equals("hierarchy") || handleType.equals("level")) {
            updatedReference = this.mRefID;
        }
        this.clearRefID();
        this.mRefID = new StringBuilder("RoleValue('");
        this.mRefID.append(name);
        this.mRefID.append("'");
        MAWorkingLocales workingLocales = this.getWorkingLocales();
        MAGlobalsProcessor globProc = new MAGlobalsProcessor(this.getMFWGateway(), workingLocales);
        Locale authLocale = LocaleConverter.strToLocale(workingLocales.getAuthoringLocale());
        String decSeparator = globProc.getListSeparator(authLocale);
        this.mRefID.append(decSeparator);
        this.mRefID.append((CharSequence)updatedReference);
        this.mRefID.append(")");
    }

    public void buildRefIDFull(String name, short originalType, short targetType, MFWNodeHandle handle, boolean last) {
        if (originalType == MFWModelRes.getInstance().RID_shortcut) {
            int index;
            if (this.isFolderType(this.mLastRefType) && (index = this.mRefID.lastIndexOf(".[")) != -1) {
                String substr = this.mRefID.substring(0, index);
                this.mRefID = new StringBuilder(substr);
            }
            if (targetType == MFWModelRes.getInstance().RID_namespace) {
                this.mRefID = new StringBuilder();
            } else if (!last && this.isFolderType(targetType)) {
                this.mRefID = new StringBuilder();
                MFWNodeHandle parent = handle.getParent();
                short type = parent.getInfo().getRID();
                while (this.isFolderType(type)) {
                    parent = parent.getParent();
                    type = parent.getInfo().getRID();
                }
                this.mRefID.append(this.buildRefPath(parent));
            }
            if (this.mRefID.length() > 0) {
                this.mRefID.append(".");
            }
            this.mRefID.append(UniqueNameGenerator.createUniqueName(name));
            this.mLastRefType = targetType;
            this.mLastOrigRefType = originalType;
            this.mLastHandle = handle;
            return;
        }
        this.buildRefID(name, originalType, targetType, handle);
    }

    public boolean isFolderType(short type) {
        return type == RID_FOLDER || type == RID_QUERYITEMFOLDER || type == RID_HIERARCHYFOLDER || type == RID_MEASUREFOLDER;
    }

    public void buildPathID(String name) {
        if (this.mPathID.length() > 0) {
            this.mPathID.append(".");
        }
        this.mPathID.append("[");
        if (name == null) {
            this.mPathID.append("");
        } else {
            this.mPathID.append(name);
        }
        this.mPathID.append("]");
    }

    public String buildFullPath(MFWNodeHandle handle) {
        if (handle == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        if (handle.getInfo().getRID() != RID_PROJECT) {
            String name = this.getName(handle, MAWorkingLocales.getRunLocale());
            String app = ".";
            if (path.length() == 0) {
                app = "";
            }
            path.append(app);
            path.append("[");
            if (name == null) {
                path.append("");
            } else {
                path.append(name);
            }
            path.append("]");
            for (MFWNodeHandle parentHandle = handle.getParent(); parentHandle != null && parentHandle.getInfo().getRID() != RID_PROJECT && (name = this.getName(parentHandle, MAWorkingLocales.getRunLocale())) != null; parentHandle = parentHandle.getParent()) {
                path.insert(0, ".");
                path.insert(0, "]");
                path.insert(0, name);
                path.insert(0, "[");
            }
        }
        return path.toString();
    }

    public String buildFullPath(MFWNodeHandle[] handles) {
        if (handles == null || handles.length == 0) {
            return "";
        }
        StringBuilder path = new StringBuilder();
        for (int i = handles.length - 1; i >= 0; --i) {
            if (i - 1 >= 0 && handles[i - 1].getNameRID() == MFWModelRes.getInstance().RID_shortcut) continue;
            String name = this.getName(handles[i], MAWorkingLocales.getRunLocale());
            if (i != handles.length - 1) {
                path.insert(0, ".");
            }
            path.insert(0, "]");
            path.insert(0, name);
            path.insert(0, "[");
        }
        return path.toString();
    }

    public String buildRefPath(MFWNodeHandle handle) {
        if (handle == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        if (handle.getInfo().getRID() != RID_PROJECT) {
            String name = this.getName(handle, MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID()));
            if (name != null) {
                String app = ".";
                if (path.length() == 0) {
                    app = "";
                }
                path.append(app);
                path.append("[");
                path.append(name);
                path.append("]");
            }
            if (handle.getInfo().getRID() != RID_NAMESPACE) {
                for (MFWNodeHandle parentHandle = handle.getParent(); parentHandle != null; parentHandle = parentHandle.getParent()) {
                    short type = parentHandle.getInfo().getRID();
                    if (this.isFolderType(type)) continue;
                    if (type == RID_PROJECT || (name = this.getName(parentHandle, MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID()))) == null) break;
                    path.insert(0, ".");
                    path.insert(0, "]");
                    path.insert(0, name);
                    path.insert(0, "[");
                    if (type == RID_NAMESPACE) break;
                }
            }
        }
        return path.toString();
    }

    public ArrayList<String> buildSchemaXPathToRoot(MFWNodeHandle handle) {
        String folder = "folder";
        ArrayList<String> xpath = new ArrayList<String>();
        if (handle != null) {
            String name = handle.getInfo().getName();
            if (handle.getInfo().getRID() == MFWModelRes.getInstance().RID_namespace) {
                xpath.add(folder);
            } else {
                xpath.add(name);
            }
            for (MFWNodeHandle parent = handle.getParent(); parent != null; parent = parent.getParent()) {
                name = parent.getInfo().getName();
                if (parent.getInfo().getRID() == MFWModelRes.getInstance().RID_project) break;
                if (parent.getInfo().getRID() == MFWModelRes.getInstance().RID_namespace) {
                    xpath.add(folder);
                    continue;
                }
                xpath.add(name);
            }
        }
        return xpath;
    }

    public String removeLastToken(String refID) {
        if (refID == null) {
            return null;
        }
        int index = refID.lastIndexOf(".");
        if (index != -1) {
            return refID.substring(0, index);
        }
        return refID;
    }

    public short getLastRefType() {
        return this.mLastRefType;
    }

    public short getLastOrigRefType() {
        return this.mLastOrigRefType;
    }

    public MFWNodeHandle getLastHandle() {
        return this.mLastHandle;
    }
}

