/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.ma4j.framework.MAIDManager;
import com.cognos.xqe.ma4j.framework.MAWorkingLocales;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class MAObjectBrowser {
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private String localeEn = "en";
    private Boolean useDesignLocaleForReferenceID = null;
    protected MFWGateway mPGW = null;
    private MFWNodeHandle mProjectNode = null;
    private MAWorkingLocales mWorkingLocales = null;
    private static final String NAME = "name";
    protected static final MFWModelRes MODEL_RES = MFWModelRes.getInstance();

    protected MAObjectBrowser(MFWGateway pGW, MAWorkingLocales locales) {
        this.mPGW = pGW;
        this.mWorkingLocales = locales;
    }

    protected MFWNodeHandle getProjectNode() {
        if (this.mProjectNode == null && this.getMFWGateway() != null) {
            MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)"/project");
            MFWNodeHandle[] handles = this.getMFWGateway().query(aQuerySpec);
            this.mProjectNode = handles[0];
        }
        return this.mProjectNode;
    }

    protected boolean getUseDesignLocaleForReferenceID() {
        if (this.useDesignLocaleForReferenceID == null) {
            Boolean useDesignLocale = false;
            MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)"/project/fixIdsToDefaultLocale");
            MFWNodeHandle[] handles = this.getMFWGateway().query(aQuerySpec);
            if (handles != null && handles.length == 1) {
                useDesignLocale = "true".equals(this.mPGW.getPropertyValue(handles[0]));
            }
            this.useDesignLocaleForReferenceID = useDesignLocale;
        }
        return this.useDesignLocaleForReferenceID;
    }

    protected ArrayList<String> getProperties(MFWNodeHandle objectHandle, ArrayList<String> properties, boolean bEnumLables, int workLocaleType) {
        ArrayList<String> response = new ArrayList<String>();
        int size = properties.size();
        for (int k = 0; k < size; ++k) {
            String propName = properties.get(k);
            String value = this.getProperty(objectHandle, propName, bEnumLables, workLocaleType);
            response.add(value);
        }
        return response;
    }

    protected ArrayList<String> getProperties(MFWNodeHandle objectHandle, MFWNodeHandle shortcutTarget, Set<String> properties, Set<String> shortcutProperties, boolean bEnumLables, int workLocaleType) {
        ArrayList<String> response = new ArrayList<String>();
        for (String propName : properties) {
            String value = null;
            if (shortcutTarget != null) {
                if (shortcutProperties.contains(propName)) {
                    value = this.getProperty(objectHandle, propName, bEnumLables, workLocaleType);
                    if (value != null && value.length() == 0 && (propName.equals("screenTip") || propName.equals("description"))) {
                        value = this.getProperty(shortcutTarget, propName, bEnumLables, workLocaleType);
                    }
                } else {
                    value = this.getProperty(shortcutTarget, propName, bEnumLables, workLocaleType);
                }
            } else {
                value = this.getProperty(objectHandle, propName, bEnumLables, workLocaleType);
            }
            response.add(value);
        }
        return response;
    }

    protected String getProperty(MFWNodeHandle objectHandle, String property, boolean bEnumLables, int workingLocaleType) {
        return this.getProperty(objectHandle, property, bEnumLables, workingLocaleType, false);
    }

    protected String getProperty(MFWNodeHandle objectHandle, String property, boolean bEnumLables, int workingLocaleType, boolean localized) {
        String workLocale = this.getLocaleStringType(workingLocaleType);
        return this.getProperty(objectHandle, property, bEnumLables, workLocale, localized);
    }

    protected String getProperty(MFWNodeHandle objectHandle, String property, boolean bEnumLables, String workingLocale) {
        return this.getProperty(objectHandle, property, bEnumLables, workingLocale, false);
    }

    protected String getProperty(MFWNodeHandle objectHandle, String property, boolean bEnumLables, String workingLocale, boolean localized) {
        boolean isLocalized;
        String value = null;
        if (this.isVirtualProperty(property)) {
            return value;
        }
        if (objectHandle.getInfo().getRID() == MFWModelRes.getInstance().RID_queryItem && property.equals("_isMemberProperty")) {
            MFWNodeHandle parent = objectHandle.getParent();
            while (parent.getInfo().getRID() == MFWModelRes.getInstance().RID_queryItemFolder) {
                parent = parent.getParent();
            }
            value = parent.getInfo().getRID() == MFWModelRes.getInstance().RID_level || parent.getInfo().getRID() == MFWModelRes.getInstance().RID_hierarchy ? "true" : "false";
            return value;
        }
        MFWNodeHandle[] fHandles = null;
        MFWInfo parentInfo = objectHandle.getInfo();
        MFWInfo childInfo = this.isValidProperty(objectHandle, property);
        if (childInfo == null) {
            return value;
        }
        if (!(parentInfo.getRID() != MAObjectBrowser.MODEL_RES.RID_calculation && parentInfo.getRID() != MAObjectBrowser.MODEL_RES.RID_hierarchyNamedSet || childInfo.getRID() != MAObjectBrowser.MODEL_RES.RID_dimensions && childInfo.getRID() != MAObjectBrowser.MODEL_RES.RID_hierarchies)) {
            fHandles = this.mPGW.getObjectChildren(objectHandle, childInfo.getRID());
            if (fHandles != null && fHandles.length > 0) {
                value = this.mPGW.getObjectPropertyValue(fHandles[0], MAObjectBrowser.MODEL_RES.RID_refobj);
                MFWNodeHandle[] refObj = this.mPGW.resolveCrnID(value);
                if (refObj != null && refObj.length > 0) {
                    MAIDManager mIdManager = new MAIDManager(this.mPGW, this.mWorkingLocales);
                    value = mIdManager.buildRefPath(refObj[refObj.length - 1]);
                }
            } else if (fHandles != null && fHandles.length == 0) {
                value = "";
            }
            return value;
        }
        if (parentInfo.getRID() == MAObjectBrowser.MODEL_RES.RID_hierarchy && childInfo.getRID() == MAObjectBrowser.MODEL_RES.RID_rootMUN) {
            value = this.buildRootMun(objectHandle);
            return value;
        }
        if ((parentInfo.getRID() == MAObjectBrowser.MODEL_RES.RID_querySubject || parentInfo.getRID() == MAObjectBrowser.MODEL_RES.RID_dimension) && childInfo.getRID() == MAObjectBrowser.MODEL_RES.RID_dataSourceRef) {
            value = this.editDataSourceRef(objectHandle);
            if (value == null) {
                value = "";
            }
            return value;
        }
        boolean bl = isLocalized = childInfo.findChildInfo(MAObjectBrowser.MODEL_RES.RID_locale) != null;
        if (isLocalized) {
            value = this.getLocalizedProperty(objectHandle, childInfo.getRID(), workingLocale, localized);
            if (value == null) {
                value = "";
            }
            return value;
        }
        fHandles = this.mPGW.getObjectChildren(objectHandle, childInfo.getRID());
        if (fHandles != null && fHandles.length > 0) {
            value = this.getValue(fHandles[0], bEnumLables);
        } else if (fHandles != null && fHandles.length == 0) {
            value = "";
        }
        return value;
    }

    protected String getSimplePropertyValue(MFWNodeHandle objectHandle, short propRID) {
        String outValue = this.mPGW.getObjectPropertyValue(objectHandle, propRID);
        return outValue;
    }

    private String editDataSourceRef(MFWNodeHandle objectHandle) {
        String dataSrcID = this.getSimplePropertyValue(objectHandle, MAObjectBrowser.MODEL_RES.RID_dataSourceRef);
        if (dataSrcID == null) {
            return null;
        }
        MAIDManager mIdManager = new MAIDManager(this.mPGW, this.mWorkingLocales);
        ArrayList<String> namePartsFromDataSourceRef = mIdManager.splitID(dataSrcID);
        int size = namePartsFromDataSourceRef.size();
        String updatedValue = dataSrcID;
        if (size > 0) {
            updatedValue = namePartsFromDataSourceRef.get(size - 1);
        }
        return updatedValue;
    }

    protected String getCurrentRefId(MFWNodeHandle objectHandle) {
        return this.getSimplePropertyValue(objectHandle, MAObjectBrowser.MODEL_RES.RID_ID);
    }

    private String buildRootMun(MFWNodeHandle objectHandle) {
        String levelId;
        String updatedRootMUN;
        block5: {
            updatedRootMUN = null;
            String modelRootMun = this.getSimplePropertyValue(objectHandle, MAObjectBrowser.MODEL_RES.RID_rootMUN);
            updatedRootMUN = modelRootMun;
            if (updatedRootMUN != null) {
                updatedRootMUN = "->" + updatedRootMUN;
            }
            levelId = "";
            MFWNodeHandle[] fLevels = null;
            try {
                fLevels = this.mPGW.getObjectChildren(objectHandle, MAObjectBrowser.MODEL_RES.RID_level);
                if (fLevels == null) break block5;
                int levelColSize = fLevels.length;
                if (levelColSize == 0 && updatedRootMUN != null) {
                    String currentRefId = this.getCurrentRefId(objectHandle);
                    updatedRootMUN = new StringBuilder(updatedRootMUN).insert(0, currentRefId).toString();
                }
                for (int i = 0; i < levelColSize; ++i) {
                    String externalOrdinal = this.getSimplePropertyValue(fLevels[i], MAObjectBrowser.MODEL_RES.RID_externalOrdinal);
                    int ordinal = Integer.valueOf(externalOrdinal);
                    if (ordinal < 0) continue;
                    String currentRefId = this.getCurrentRefId(objectHandle);
                    StringBuilder sb = new StringBuilder();
                    sb.append(currentRefId);
                    sb.append(".[");
                    sb.append(this.getName(fLevels[i], MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID())));
                    sb.append("]");
                    levelId = sb.toString();
                    break;
                }
            }
            catch (MFWException t) {
                mErrorLogger.log(t);
                return modelRootMun;
            }
        }
        updatedRootMUN = updatedRootMUN != null ? new StringBuilder(updatedRootMUN).insert(0, levelId).toString() : "";
        return updatedRootMUN;
    }

    protected String getLocalizedProperty(MFWNodeHandle objectHandle, short ridProp, String locale) {
        return this.getLocalizedProperty(objectHandle, ridProp, locale, false);
    }

    protected String getLocalizedProperty(MFWNodeHandle objectHandle, short ridProp, String locale, boolean localized) {
        String value = null;
        String currentLocale = locale;
        value = this.queryLocalizedPropertyValue(objectHandle, ridProp, currentLocale, localized);
        if (value != null) {
            return value;
        }
        String defaultLocale = this.mWorkingLocales.getDefaultLocale();
        value = this.queryLocalizedPropertyValue(objectHandle, ridProp, defaultLocale);
        if (value != null) {
            return value;
        }
        Set<String> locales = this.mWorkingLocales.getSupportedLocales();
        Iterator<String> it = locales.iterator();
        while (it.hasNext() && value == null) {
            currentLocale = it.next();
            if (currentLocale.equals(locale) || currentLocale.equals(defaultLocale)) continue;
            value = this.queryLocalizedPropertyValue(objectHandle, ridProp, currentLocale);
        }
        return value;
    }

    protected String queryLocalizedPropertyValue(MFWNodeHandle objectHandle, short ridPropName, String locale) {
        return this.queryLocalizedPropertyValue(objectHandle, ridPropName, locale, false);
    }

    protected String queryLocalizedPropertyValue(MFWNodeHandle objectHandle, short ridPropName, String locale, boolean localized) {
        String outValue = null;
        MFWNodeHandle[] localizedProps = this.mPGW.findChildObjects(objectHandle, ridPropName, MAObjectBrowser.MODEL_RES.RID_locale, locale);
        if (localizedProps != null && localizedProps.length > 0) {
            int index = 0;
            if (localized) {
                index = localizedProps.length - 1;
            }
            outValue = this.mPGW.getObjectPropertyValue(localizedProps[index], MAObjectBrowser.MODEL_RES.RID__Value);
        }
        return outValue;
    }

    protected String getName(MFWNodeHandle objectHandle, int isExpressionType) {
        return this.getName(objectHandle, isExpressionType, false);
    }

    protected String getName(MFWNodeHandle objectHandle, int isExpressionType, boolean localized) {
        return this.getProperty(objectHandle, NAME, false, isExpressionType, localized);
    }

    protected String getValue(MFWNodeHandle objectHandle, boolean bEnumLables) {
        String value = null;
        String zero = "0";
        String one = "1";
        if (objectHandle != null && objectHandle.getInfo().getNodeType() == 1) {
            MFWInfoProperty propInfo = (MFWInfoProperty)objectHandle.getInfo();
            if (!bEnumLables) {
                if (propInfo.getDataType() == 2) {
                    int intValue = this.mPGW.getEnumPropertyValue(objectHandle);
                    value = Integer.toString(intValue);
                } else if (propInfo.getDataType() == 4) {
                    boolean boolValue = this.mPGW.getBooleanPropertyValue(objectHandle);
                    value = zero;
                    if (boolValue) {
                        value = one;
                    }
                } else {
                    value = this.mPGW.getPropertyValue(objectHandle);
                }
            } else if (propInfo.getDataType() == 4) {
                boolean boolValue = this.mPGW.getBooleanPropertyValue(objectHandle);
                value = zero;
                if (boolValue) {
                    value = one;
                }
            } else {
                value = this.mPGW.getPropertyValue(objectHandle);
            }
        }
        return value;
    }

    protected MFWNodeHandle findObjectByIDName(MFWNodeHandle parentHandle, String idName) {
        String exprLocale;
        String defaultLocale;
        String runLocale;
        MFWNodeHandle resultHandle = null;
        MFWNodeHandle[] handles = null;
        String queryPath = new String("*");
        MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)queryPath);
        handles = parentHandle == null ? this.mPGW.query(aQuerySpec) : this.mPGW.queryObject(parentHandle, aQuerySpec);
        if (handles != null && (resultHandle = this.findObjectByMatchingName(handles, idName, runLocale = this.getLocaleStringType(MAWorkingLocales.getRunLocale()))) == null && (resultHandle = this.findObjectByMatchingName(handles, idName, defaultLocale = this.mWorkingLocales.getDefaultLocale())) == null && (resultHandle = this.findObjectByMatchingName(handles, idName, exprLocale = this.getLocaleStringType(MAWorkingLocales.getExpressionLocale()))) == null) {
            Set<String> locales = this.mWorkingLocales.getSupportedLocales();
            Iterator<String> it = locales.iterator();
            String currentLocale = this.localeEn;
            while (it.hasNext() && resultHandle == null) {
                currentLocale = it.next();
                if (currentLocale.equals(runLocale) || currentLocale.equals(defaultLocale) || currentLocale.equals(exprLocale)) continue;
                resultHandle = this.findObjectByMatchingName(handles, idName, currentLocale);
            }
        }
        return resultHandle;
    }

    protected MFWNodeHandle findObjectByMatchingName(MFWNodeHandle[] handles, String idName, String workingLocale) {
        MFWNodeHandle resultHandle = null;
        for (int k = 0; k < handles.length; ++k) {
            String name;
            MFWNodeHandle handle = handles[k];
            MFWInfo info = handle.getInfo();
            if (info.getNodeType() != 2 || (name = this.getProperty(handle, NAME, false, workingLocale)) == null || name.compareTo(idName) != 0) continue;
            resultHandle = handle;
            break;
        }
        return resultHandle;
    }

    private String getLocaleStringType(int localeType) {
        String workLocale = this.mWorkingLocales.getWorkingLocale(localeType);
        if (workLocale == null) {
            workLocale = this.localeEn;
        } else if (workLocale.length() == 0) {
            workLocale = this.localeEn;
        }
        return workLocale;
    }

    protected MFWNodeHandle getParentNamespace(MFWNodeHandle child) {
        return this.getParent(child, MAObjectBrowser.MODEL_RES.RID_namespace);
    }

    protected MFWNodeHandle getParentDimension(MFWNodeHandle child) {
        return this.getParent(child, MAObjectBrowser.MODEL_RES.RID_dimension);
    }

    protected MFWNodeHandle getParent(MFWNodeHandle child, short parentType) {
        MFWNodeHandle parent = child.getParent();
        short type = parent.getInfo().getRID();
        while (type != parentType) {
            if ((parent = parent.getParent()) == null) {
                return null;
            }
            type = parent.getInfo().getRID();
        }
        return parent;
    }

    protected MFWGateway getMFWGateway() {
        return this.mPGW;
    }

    protected MAWorkingLocales getWorkingLocales() {
        return this.mWorkingLocales;
    }

    private boolean isVirtualProperty(String name) {
        return name.equals("_path") || name.equals("_ref");
    }

    private MFWInfo isValidProperty(MFWNodeHandle parent, String propName) {
        short type;
        MFWInfo info = parent.getInfo();
        MFWInfo childInfo = info.findChildInfo(propName);
        if (childInfo != null && propName.equals("dimension") && (type = childInfo.getNodeType()) != 1) {
            childInfo = null;
        }
        return childInfo;
    }
}

