/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.ma4j.framework.MAConstraint;
import com.cognos.xqe.ma4j.framework.MAGlobalsProcessor;
import com.cognos.xqe.ma4j.framework.MAMetadataParameters;
import com.cognos.xqe.ma4j.framework.MAQueryInfo;
import com.cognos.xqe.ma4j.framework.MAWorkingLocales;
import com.cognos.xqe.runtree.ma.MAXNodeRuntimeException;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.LocaleConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class MAQueryParser {
    private Map<String, String> mAttributes = null;
    private ArrayList<String> mProperties = null;
    private Node mConstraintNode = null;
    private MAQueryInfo mQueryInfo = null;
    private MAConstraint mConstraint = null;
    private boolean mIsFunctionRequest = false;
    private MAWorkingLocales mWorkingLocales = null;
    private MAMetadataParameters mMetadataParameters = null;
    boolean mEnumLables = true;
    private String mStartAtPath = "start_atPath";
    private String mAuthorinLocale = "authoringLocale";
    private String mEn = "en";
    private String mStartAtRef = "start_atRef";

    public MAQueryParser() {
        this.initialize();
    }

    private void initialize() {
        this.mProperties = new ArrayList();
        this.mAttributes = new HashMap<String, String>();
        this.mWorkingLocales = new MAWorkingLocales();
        this.mQueryInfo = new MAQueryInfo();
    }

    public void processClientRequest(Element domRequest) {
        try {
            this.processNode(domRequest);
            this.processEnumLabelsHelper();
        }
        catch (Throwable t) {
            throw new MAXNodeRuntimeException(XQEMessageKeys.MA_InvalidQuery, t);
        }
        this.postParseProcessing();
    }

    public MAQueryInfo getQueryInfo() {
        return this.mQueryInfo;
    }

    public boolean getEnumLabels() {
        return this.mEnumLables;
    }

    private void processEnumLabelsHelper() {
        String enumLables = this.getValueForAttribute("_enumLabels");
        if (enumLables != null) {
            Integer enumLab = Integer.valueOf(enumLables);
            if (enumLab == 0) {
                this.mEnumLables = false;
            } else if (enumLab == 1) {
                this.mEnumLables = true;
            }
        } else {
            this.mEnumLables = false;
        }
    }

    private void processNode(Element node) {
        boolean isMetadataNode = false;
        boolean isFunctionNode = false;
        boolean isActionsNode = false;
        String parentName = null;
        String nodeName = node.getName();
        if (nodeName.equals("Metadata")) {
            isMetadataNode = true;
        } else if (nodeName.equals("Functions")) {
            isFunctionNode = true;
        } else if (nodeName.equals("Actions")) {
            isActionsNode = true;
        }
        int nAttributes = node.attributeCount();
        for (int count = 0; count < nAttributes; ++count) {
            Attribute attribute = node.attribute(count);
            String attValue = attribute.getValue();
            if (attValue == null) continue;
            if (isMetadataNode || isFunctionNode || isActionsNode) {
                String attName;
                if (isFunctionNode) {
                    this.mAttributes.put("function", "one");
                    this.mIsFunctionRequest = true;
                }
                if ((attName = attribute.getName()).equals("start_at")) {
                    attName = this.mStartAtPath;
                }
                this.mAttributes.put(attName, attValue);
                continue;
            }
            if (nodeName.equals("Property")) {
                this.mProperties.add(attValue);
                continue;
            }
            if (nodeName.equals("runLocale")) {
                this.mQueryInfo.setRunLocale(attValue);
                continue;
            }
            if (nodeName.equals("productLocale")) {
                this.mQueryInfo.setProductLocale(attValue);
                continue;
            }
            if (nodeName.equals("dataSource")) {
                this.mQueryInfo.setDataSource(attValue);
                continue;
            }
            if (!nodeName.equals("Path")) continue;
            Element parentNode = node.getParent();
            if (parentNode != null) {
                parentName = parentNode.getName();
            }
            if (parentName.equals("Start_at")) {
                this.mQueryInfo.setStartAtPathCollection(attValue);
                continue;
            }
            if (!parentName.equals(this.mStartAtRef)) continue;
            this.mQueryInfo.setStartAtRefCollection(attValue);
        }
        if (nodeName.equals("Constraints")) {
            this.setConstraintElement(node);
        }
        Iterator it = CollectionCast.uncheckedCast(node.elements().iterator());
        while (it.hasNext()) {
            this.processNode((Element)it.next());
        }
    }

    String getValueForAttribute(String attName) {
        String attrValue = null;
        if (this.mAttributes.containsKey(attName)) {
            attrValue = this.mAttributes.get(attName);
        }
        return attrValue;
    }

    public ArrayList<String> getProperties() {
        return this.mProperties;
    }

    public boolean hasConstraints() {
        return this.mConstraintNode != null;
    }

    public MAConstraint getConstraint() {
        return this.mConstraint;
    }

    public void setConstraintElement(Element node) {
        List children = CollectionCast.uncheckedCast(node.elements());
        for (int i = 0; i < children.size(); ++i) {
            this.mConstraintNode = (Node)children.get(i);
            if (this.mConstraintNode.getNodeType() == 1) break;
        }
    }

    public String getStartAtPath() {
        if (this.mQueryInfo.getStartAtPath() == null) {
            this.mQueryInfo.setStartAtPath(this.getValueForAttribute(this.mStartAtPath));
        }
        return this.mQueryInfo.getStartAtPath();
    }

    public String getStartAtRef() {
        if (this.mQueryInfo.getStartAtRef() == null) {
            this.mQueryInfo.setStartAtRef(this.getValueForAttribute(this.mStartAtRef));
        }
        return this.mQueryInfo.getStartAtRef();
    }

    public Set<String> getStartAtPathCollection() {
        return this.mQueryInfo.getStartAtPathCollection();
    }

    public Set<String> getStartAtRefCollection() {
        return this.mQueryInfo.getStartAtRefCollection();
    }

    public String getAuthoringLocale() {
        if (this.mQueryInfo.getAuthoringLocale() == null) {
            this.mQueryInfo.setAuthoringLocale(this.getValueForAttribute(this.mAuthorinLocale));
        }
        return this.mQueryInfo.getAuthoringLocale();
    }

    public void setRunLocale(String locale) {
        this.mQueryInfo.setRunLocale(locale);
    }

    public String getRunLocale() {
        return this.mQueryInfo.getRunLocale();
    }

    public void setProductLocale(String locale) {
        this.mQueryInfo.setProductLocale(locale);
    }

    public String getProductLocale() {
        return this.mQueryInfo.getProductLocale();
    }

    public String getDataSource() {
        return this.mQueryInfo.getDataSource();
    }

    public String getModelSearchPath() {
        return this.mQueryInfo.getModelSearchPath();
    }

    public void setModelSearchPath(String modelSearchPath) {
        this.mQueryInfo.setModelSearchPath(modelSearchPath);
    }

    public void setDataSource(String connectionString) {
        this.mQueryInfo.setDataSource(connectionString);
    }

    public String getCAMPassport() {
        return this.mQueryInfo.getCAMPassport();
    }

    public void setCAMPassport(String passport) {
        this.mQueryInfo.setCAMPassport(passport);
    }

    public MAWorkingLocales getWorkingLocales() {
        return this.mWorkingLocales;
    }

    public boolean isFunctionRequest() {
        return this.mIsFunctionRequest;
    }

    private void processLocales() {
        if (this.mQueryInfo.getAuthoringLocale().length() == 0) {
            this.mQueryInfo.setAuthoringLocale(this.mEn);
        }
        if (this.mQueryInfo.getRunLocale().length() == 0) {
            this.mQueryInfo.setRunLocale(this.mEn);
        }
        this.mWorkingLocales.setEffectiveLocale(this.mQueryInfo.getRunLocale());
        this.mWorkingLocales.setAuthoringLocale(this.mQueryInfo.getAuthoringLocale());
    }

    public void calcEffectiveAuthoringLocales(MFWGateway gw) {
        MAGlobalsProcessor gp = new MAGlobalsProcessor(gw, this.mWorkingLocales);
        Locale runLocale = LocaleConverter.strToLocale(this.mQueryInfo.getRunLocale());
        Locale authoringLocale = LocaleConverter.strToLocale(this.mQueryInfo.getAuthoringLocale());
        String effective = this.mQueryInfo.getRunLocale();
        String authoring = this.mQueryInfo.getAuthoringLocale();
        try {
            effective = gp.getEffectiveContentLocale(runLocale);
            authoring = gp.getEffectiveExpressionLocale(authoringLocale);
        }
        catch (CCLConfigurationException e) {
            throw new XQERuntimeException(e);
        }
        String defaultLocale = gp.getDefaultLocale();
        Set<String> locales = gp.getSupportedLocales();
        this.mWorkingLocales.setEffectiveLocale(effective);
        this.mWorkingLocales.setAuthoringLocale(authoring);
        this.mWorkingLocales.setDefaultLocale(defaultLocale);
        this.mWorkingLocales.setSupportedLocals(locales);
    }

    public void initialize(MAMetadataParameters metadataParameters) {
        this.mQueryInfo = metadataParameters.getQueryInfo();
        this.mAttributes = metadataParameters.getAttributes();
        this.mMetadataParameters = metadataParameters;
        this.postParseProcessingStartingPoint();
    }

    public MAMetadataParameters getMetadataParameters() {
        return this.mMetadataParameters;
    }

    public int getDepth() {
        int depth = -1;
        if (this.mMetadataParameters != null) {
            depth = this.mMetadataParameters.getDepth();
            if (depth != -1) {
                --depth;
            }
        } else {
            String sDepth = this.getValueForAttribute("Depth");
            if (sDepth != null && sDepth.length() > 0) {
                depth = Integer.valueOf(sDepth);
                --depth;
            }
        }
        return depth;
    }

    private void postParseProcessing() {
        this.mQueryInfo.setAuthoringLocale(this.getValueForAttribute(this.mAuthorinLocale));
        this.mQueryInfo.setStartAtPath(this.getValueForAttribute(this.mStartAtPath));
        this.mQueryInfo.setStartAtRef(this.getValueForAttribute(this.mStartAtRef));
        this.postParseProcessingStartingPoint();
    }

    private void postParseProcessingStartingPoint() {
        this.processLocales();
    }
}

