/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.xqe.ma4j.framework.MAIDManager;
import com.cognos.xqe.ma4j.framework.MAObjectBrowser;
import com.cognos.xqe.ma4j.framework.MAResolverPathInt;
import com.cognos.xqe.ma4j.framework.MAShortcutProcessor;
import com.cognos.xqe.ma4j.framework.MAWorkingLocales;
import com.cognos.xqe.util.UniqueNameParser;
import java.util.ArrayList;

public class MAResolverRefPath
extends MAObjectBrowser
implements MAResolverPathInt {
    private MFWGateway mPGW = null;
    private String mRefID = null;
    private String mPathID = null;
    private MAShortcutProcessor mMAShortcutProcessor = null;
    private MAIDManager mIdManager = null;
    private short mLastRefType = (short)-1;
    private short mLastTargetRefType = (short)-1;
    private boolean mStartContainsShortcut = false;

    public MAResolverRefPath(MFWGateway pGW, MAWorkingLocales locales) {
        super(pGW, locales);
        this.mPGW = pGW;
        this.mMAShortcutProcessor = new MAShortcutProcessor(pGW);
        this.mIdManager = new MAIDManager(pGW, locales);
    }

    @Override
    public MFWNodeHandle resolvePath(String refPath, MFWNodeHandle parentObject) {
        this.mRefID = null;
        this.mPathID = null;
        this.mStartContainsShortcut = false;
        MFWNodeHandle resHandle = parentObject;
        MAResolverObjectReference objRef = null;
        boolean isShortcut = false;
        StringBuilder id = new StringBuilder();
        ArrayList<String> tokens = this.mIdManager.splitID(refPath);
        if (tokens.size() > 0) {
            for (int k = 0; k < tokens.size(); ++k) {
                if (k > 0) {
                    id.append(".");
                }
                id.append(tokens.get(k));
                objRef = this.getRefTarget(id.toString(), parentObject);
                parentObject = objRef.getObjectHandle();
                isShortcut = objRef.isShortcut();
                this.mStartContainsShortcut = this.mStartContainsShortcut || objRef.isShortcut();
                resHandle = objRef.getTargetHandle();
                String translatedID = objRef.getTranslatedID();
                String normalizedTransID = UniqueNameParser.escapeSquareBrackets(translatedID);
                id.replace(0, id.length(), this.replaceLastToken(id.toString(), normalizedTransID));
            }
        }
        this.mRefID = id.toString();
        MFWNodeHandle[] handles = this.mPGW.resolveCrnID(this.mRefID);
        this.mPathID = this.mIdManager.buildFullPath(handles);
        if (null != resHandle) {
            this.mLastRefType = this.mLastTargetRefType = resHandle.getInfo().getRID();
        }
        if (isShortcut && null != parentObject) {
            this.mLastRefType = parentObject.getInfo().getRID();
            return parentObject;
        }
        return resHandle;
    }

    private String replaceLastToken(String id, String lastToken) {
        String res = id;
        boolean hasDot = true;
        int index = id.lastIndexOf(".[");
        if (index == -1) {
            hasDot = false;
            index = id.lastIndexOf("[");
        }
        if (index != -1) {
            String append = "";
            if (hasDot) {
                append = ".";
            }
            res = id.substring(0, index) + append + "[" + lastToken + "]";
        }
        return res;
    }

    @Override
    public String getPathID() {
        return this.mPathID;
    }

    @Override
    public String getRefID() {
        return this.mRefID;
    }

    private MAResolverObjectReference getRefTarget(String refPath, MFWNodeHandle parentObject) {
        MFWNodeHandle shortcutTargetHandle = null;
        MFWNodeHandle handle = null;
        boolean isShortcut = false;
        MFWNodeHandle[] result = this.mPGW.resolveCrnID(refPath);
        String translatedName = "";
        if (result.length > 0 && (handle = result[result.length - 1]) != null) {
            translatedName = this.getName(handle, MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID()));
            isShortcut = this.mMAShortcutProcessor.isShortcut(handle);
            shortcutTargetHandle = isShortcut ? this.mMAShortcutProcessor.processShortcuts(handle) : handle;
        }
        MAResolverObjectReference objRef = new MAResolverObjectReference(handle, shortcutTargetHandle, isShortcut, translatedName);
        return objRef;
    }

    @Override
    public short getLastRefType() {
        return this.mLastRefType;
    }

    @Override
    public boolean getStartContainsShortcut() {
        return this.mStartContainsShortcut;
    }

    public class MAResolverObjectReference {
        private MFWNodeHandle mObjectHandle = null;
        private MFWNodeHandle mTargetHandle = null;
        boolean mIsShortcut = false;
        private String mTranslatedID = null;

        public MAResolverObjectReference(MFWNodeHandle objectHandle, MFWNodeHandle targetHandle, boolean isShortcut, String translatedID) {
            this.mObjectHandle = objectHandle;
            this.mTargetHandle = targetHandle;
            this.mIsShortcut = isShortcut;
            this.mTranslatedID = translatedID;
        }

        public boolean isShortcut() {
            return this.mIsShortcut;
        }

        public MFWNodeHandle getObjectHandle() {
            return this.mObjectHandle;
        }

        public MFWNodeHandle getTargetHandle() {
            return this.mTargetHandle;
        }

        public String getTranslatedID() {
            return this.mTranslatedID;
        }
    }
}

