/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MAShortcutProcessor {
    private MFWGateway mPGW = null;

    public MAShortcutProcessor(MFWGateway pGW) {
        this.mPGW = pGW;
    }

    public boolean isShortcut(MFWNodeHandle handle) {
        if (handle != null) {
            return handle.getNameRID() == MFWModelRes.getInstance().RID_shortcut;
        }
        return false;
    }

    public MFWNodeHandle processShortcuts(MFWNodeHandle handle) {
        MFWNodeHandle resHandle = null;
        if (this.isShortcut(handle)) {
            resHandle = this.mPGW.getObjectReferencePropertyValue(handle, MFWModelRes.getInstance().RID_refobj);
        }
        return resHandle;
    }

    public String getReferenceObjectID(MFWNodeHandle handle) {
        String id = this.mPGW.getObjectPropertyValue(handle, MFWModelRes.getInstance().RID_refobj);
        return id;
    }

    public Map<String, ArrayList<MFWNodeHandle>> getShortcuts() {
        HashMap<String, ArrayList<MFWNodeHandle>> map = new HashMap<String, ArrayList<MFWNodeHandle>>();
        MFWNodeHandle[] shortcuts = this.mPGW.lookupObjectsByType((short)243);
        if (shortcuts != null) {
            for (int k = 0; k < shortcuts.length; ++k) {
                MFWNodeHandle shortcut = shortcuts[k];
                ArrayList handles = null;
                String refObjHandle = this.getReferenceObjectID(shortcut);
                if (!map.containsKey(refObjHandle)) {
                    handles = new ArrayList();
                    map.put(refObjHandle, handles);
                } else {
                    handles = (ArrayList)map.get(refObjHandle);
                }
                handles.add(shortcut);
            }
        }
        return map;
    }
}

