/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata;

import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IVariable;
import java.util.List;

public interface ICube
extends IMetadata {
    public CubeTypeEnum getType();

    @Override
    public String getUniqueName();

    public DateTimeValue getCreatedDate();

    public DateTimeValue getUpdatedDate();

    public DateTimeValue getSchemaUpdatedDate();

    public List<IDimension> getDimensions();

    public int getDimensionCount();

    public IDimension getDimension(String var1);

    public IHierarchy getHierarchy(String var1);

    public IHierarchy getMeasuresHierarchy();

    public int getDimensionIndex(IDimension var1);

    public IDimension getDimension(int var1);

    public boolean getPropagateNulls();

    public ICatalog getCatalog();

    public IMeasure getDefaultMeasure();

    public CubeSuppressionTypeEnum getSuppressionType();

    public INamespace getNamespace();

    public IModelDataSource getModelDataSource();

    public List<IVariable> getVariables();

    public IDimension getMeasureDimension();

    public IDimension queryDimension(String var1);

    public boolean hasSAPReplacementVariable();

    public boolean isReplacementVariableUsed(IDimension var1);

    public String getCubeCurrentPeriod();

    public static enum CubeTypeEnum {
        DMR,
        ESSBASE,
        MICROSOFT,
        POWERCUBE,
        ROLAP,
        SAP,
        TM1,
        TMR;

    }

    public static enum CubeSuppressionTypeEnum {
        NONE("none"),
        NULL("null"),
        ZERO("zero"),
        NULL_AND_ZERO("nullAndZero");

        private final String mddsStringType;

        private CubeSuppressionTypeEnum(String theMDDSString) {
            this.mddsStringType = theMDDSString;
        }

        public String toMDDSType() {
            return this.mddsStringType;
        }

        public static CubeSuppressionTypeEnum fromMDDSTypeString(String mddsType) {
            for (CubeSuppressionTypeEnum e : CubeSuppressionTypeEnum.values()) {
                if (!e.toMDDSType().equals(mddsType)) continue;
                return e;
            }
            return NONE;
        }
    }
}

