/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata;

import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDbDimension;
import com.cognos.xqe.metadata.IDbMeasureDimension;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.MetadataUtil;

public enum MetadataType {
    CUBE,
    DIMENSION,
    HIERARCHY,
    LEVEL,
    MEMBER,
    MEASURE,
    QUERY_ITEM,
    PROPERTY,
    NAMED_SET,
    CALCULATION,
    ACTION,
    ALIAS,
    CATALOG,
    DATABASE,
    DATASOURCE,
    EMBEDDED_FILTER,
    FILTER,
    FOLDER,
    MACRO,
    NAMESPACE,
    PROJECT,
    QUERY_SUBJECT,
    RELATIONSHIP,
    SCOPE_RELATIONSHIP,
    SHORTCUT,
    VARIABLE,
    RELATIONSHIPSHORTCUT,
    DETERMINANT,
    SECURITYOBJECT,
    SECURITYFILTERBASEDON,
    MODELDATASECURITYOBJECT,
    FUNCTION,
    INDEX;


    public static boolean isAction(IMetadata metadata) {
        return metadata.getObjectType() == ACTION;
    }

    public static boolean isAlias(IMetadata metadata) {
        return metadata.getObjectType() == ALIAS;
    }

    public static boolean isCalculation(IMetadata metadata) {
        return metadata.getObjectType() == CALCULATION;
    }

    public static boolean isCatalog(IMetadata metadata) {
        return metadata.getObjectType() == CATALOG;
    }

    public static boolean isCube(IMetadata metadata) {
        return metadata.getObjectType() == CUBE;
    }

    public static boolean isDatabase(IMetadata metadata) {
        return metadata.getObjectType() == DATABASE;
    }

    public static boolean isDatasource(IMetadata metadata) {
        return metadata.getObjectType() == DATASOURCE;
    }

    public static boolean isDimension(IMetadata metadata) {
        return metadata.getObjectType() == DIMENSION;
    }

    public static boolean isFolder(IMetadata metadata) {
        return metadata.getObjectType() == FOLDER;
    }

    public static boolean isHierarchy(IMetadata metadata) {
        return metadata.getObjectType() == HIERARCHY;
    }

    public static boolean isLevel(IMetadata metadata) {
        return metadata.getObjectType() == LEVEL;
    }

    public static boolean isMacro(IMetadata metadata) {
        return metadata.getObjectType() == MACRO;
    }

    public static boolean isMeasure(IMetadata metadata) {
        if (metadata.getObjectType() == MEASURE) {
            return true;
        }
        if (metadata.getObjectType() == MEMBER) {
            return ((IMember)metadata).isMeasure();
        }
        return false;
    }

    public static boolean isMeasureDimension(IMetadata metadata) {
        if (metadata.getObjectType() == MEASURE) {
            return true;
        }
        if (metadata.getObjectType() == MEMBER) {
            return ((IMember)metadata).isMeasure();
        }
        if (metadata.getObjectType() == DIMENSION) {
            return ((IDimension)metadata).isMeasuresDimension();
        }
        if (metadata.getObjectType() == HIERARCHY) {
            return ((IHierarchy)metadata).getDimension().isMeasuresDimension();
        }
        return false;
    }

    public static boolean isMember(IMetadata metadata) {
        return metadata.getObjectType() == MEMBER || metadata.getObjectType() == MEASURE;
    }

    public static boolean isNamedSet(IMetadata metadata) {
        return metadata.getObjectType() == NAMED_SET;
    }

    public static boolean isNamespace(IMetadata metadata) {
        return metadata.getObjectType() == NAMESPACE;
    }

    public static boolean isProject(IMetadata metadata) {
        return metadata.getObjectType() == PROJECT;
    }

    public static boolean isProperty(IMetadata metadata) {
        return metadata.getObjectType() == PROPERTY;
    }

    public static boolean isQueryItem(IMetadata metadata) {
        return metadata.getObjectType() == QUERY_ITEM;
    }

    public static boolean isRelationship(IMetadata metadata) {
        return metadata.getObjectType() == RELATIONSHIP;
    }

    public static boolean isScopeRelationship(IMetadata metadata) {
        return metadata.getObjectType() == SCOPE_RELATIONSHIP;
    }

    public static boolean isShortcut(IMetadata metadata) {
        return metadata.getObjectType() == SHORTCUT;
    }

    public static boolean isVariable(IMetadata metadata) {
        return metadata.getObjectType() == VARIABLE;
    }

    public static boolean isFilter(IMetadata metadata) {
        return metadata.getObjectType() == FILTER;
    }

    public static boolean isQuerySubject(IMetadata metadata) {
        return metadata.getObjectType() == QUERY_SUBJECT;
    }

    public static boolean isOLAP(IMetadata metadata) {
        switch (metadata.getObjectType()) {
            case CUBE: 
            case DIMENSION: 
            case HIERARCHY: 
            case LEVEL: 
            case PROPERTY: 
            case NAMED_SET: 
            case ALIAS: {
                return true;
            }
            case CALCULATION: {
                String calcType = ((ICalculation)metadata).getCalcType();
                if (!calcType.equals("namedSet")) break;
                return true;
            }
            case MEMBER: {
                IQuerySubject querySubject;
                return !(metadata instanceof IMeasure) || !((querySubject = ((IMeasure)metadata).getQuerySubject()) instanceof IDbMeasureDimension);
            }
            case QUERY_ITEM: {
                if (((IQueryItem)metadata).getHierarchy() == null) break;
                IQuerySubject querySubject = ((IQueryItem)metadata).getQuerySubject();
                return !(querySubject instanceof IDbDimension);
            }
        }
        return false;
    }

    public static boolean isROLAP(IMetadata metadata) {
        boolean isROLAPMetadata = false;
        IDimension dimension = null;
        switch (metadata.getObjectType()) {
            case CUBE: {
                ICube cube = (ICube)metadata;
                String providerCode = MetadataUtil.getProviderCode(cube);
                return DataSourceTypeEnum.isROLAP(providerCode);
            }
            case DIMENSION: {
                dimension = (IDimension)metadata;
                break;
            }
            case HIERARCHY: {
                dimension = ((IHierarchy)metadata).getDimension();
                break;
            }
            case LEVEL: {
                dimension = ((ILevel)metadata).getHierarchy().getDimension();
                break;
            }
            case PROPERTY: {
                dimension = ((IProperty)metadata).getDimension();
                break;
            }
            case NAMED_SET: {
                dimension = ((INamedSet)metadata).getDimension();
                break;
            }
            case ALIAS: {
                return MetadataType.isROLAP(metadata.getParentObject());
            }
            case CALCULATION: {
                return MetadataType.isROLAP(metadata.getParentObject());
            }
            case MEMBER: {
                dimension = ((IMember)metadata).getDimension();
                break;
            }
            case QUERY_ITEM: {
                IHierarchy hierarchy = ((IQueryItem)metadata).getHierarchy();
                if (hierarchy == null) break;
                dimension = hierarchy.getDimension();
                break;
            }
        }
        if (dimension != null) {
            ICube cube = dimension.getCube();
            String providerCode = MetadataUtil.getProviderCode(cube);
            isROLAPMetadata = DataSourceTypeEnum.isROLAP(providerCode);
        }
        return isROLAPMetadata;
    }
}

