/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata;

import java.util.EnumSet;
import java.util.HashMap;

public enum VariableTypeEnum {
    HIERARCHY("HIERARCHY", "hierarchy"),
    MEMBER("MEMBER", "member", "hierarchicalNode"),
    LEAF_MEMBER("LEAF_MEMBER", "leafMember", "characteristic"),
    NUMERIC("NUMERIC", "numeric");

    private final String mddsStringType;
    private String[] fmTypes;
    private static final HashMap<String, VariableTypeEnum> FM_TO_ENUM_MAP;

    private VariableTypeEnum(String theMDDSString, String ... theFMTypes) {
        this.mddsStringType = theMDDSString;
        this.fmTypes = theFMTypes;
    }

    public String toMDDSType() {
        return this.mddsStringType;
    }

    public String[] getFMTypes() {
        return this.fmTypes;
    }

    public static VariableTypeEnum get(String fmType) {
        VariableTypeEnum type = FM_TO_ENUM_MAP.get(fmType);
        if (type == null) {
            StringBuilder buffer = new StringBuilder("Unexpected variable type: ");
            buffer.append(fmType);
            throw new IllegalArgumentException(buffer.toString());
        }
        return type;
    }

    public static VariableTypeEnum valueOf(int ordinal) {
        for (VariableTypeEnum e : VariableTypeEnum.values()) {
            if (e.ordinal() != ordinal) continue;
            return e;
        }
        StringBuilder buffer = new StringBuilder("Invalid variable type code (");
        buffer.append(ordinal);
        buffer.append(")");
        throw new IllegalArgumentException(buffer.toString());
    }

    static {
        FM_TO_ENUM_MAP = new HashMap();
        for (VariableTypeEnum s : EnumSet.allOf(VariableTypeEnum.class)) {
            String[] fmTypes;
            for (String fmType : fmTypes = s.getFMTypes()) {
                FM_TO_ENUM_MAP.put(fmType, s);
            }
        }
    }
}

