/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.dynamic;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.dynamic.DMMetadata;

public class DMRelationship
extends DMMetadata
implements IRelationship {
    private IMetadata mLeftRefObject = null;
    private IMetadata mRightRefObject = null;
    private String mLeftMinCard = null;
    private String mLeftMaxCard = null;
    private String mRightMinCard = null;
    private String mRightMaxCard = null;
    private String mExpression = null;

    public DMRelationship(String v5UniqueName, IMetadata leftRefObject, IMetadata rightRefObject, String leftMinCard, String leftMaxCard, String rightMinCard, String rightMaxCard) {
        super(v5UniqueName);
        this.mLeftRefObject = leftRefObject;
        this.mRightRefObject = rightRefObject;
        this.mLeftMinCard = leftMinCard;
        this.mLeftMaxCard = leftMaxCard;
        this.mRightMinCard = rightMinCard;
        this.mRightMaxCard = rightMaxCard;
    }

    public DMRelationship(String v5UniqueName, IMetadata leftRefObject, IMetadata rightRefObject, String expression) {
        super(v5UniqueName);
        this.mLeftRefObject = leftRefObject;
        this.mRightRefObject = rightRefObject;
        this.mExpression = expression;
        this.mLeftMinCard = "zero";
        this.mLeftMaxCard = "one";
        this.mRightMinCard = "zero";
        this.mRightMaxCard = "one";
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.RELATIONSHIP;
    }

    @Override
    public IMetadata getLeftRefObject() {
        return this.mLeftRefObject;
    }

    @Override
    public IMetadata getRightRefObject() {
        return this.mRightRefObject;
    }

    @Override
    public String getLeftRefObjectId() {
        return this.mLeftRefObject.getID();
    }

    @Override
    public String getRightRefObjectId() {
        return this.mRightRefObject.getID();
    }

    @Override
    public Enum<IRelationship.Cardinality> getLeftCardinality() {
        return this.getCardinality(this.mLeftMinCard, this.mLeftMaxCard);
    }

    @Override
    public Enum<IRelationship.Cardinality> getRightCardinality() {
        return this.getCardinality(this.mRightMinCard, this.mRightMaxCard);
    }

    @Override
    public boolean isMany(Enum<IRelationship.Cardinality> card) {
        return card == IRelationship.Cardinality.ZERO_MANY || card == IRelationship.Cardinality.ONE_MANY;
    }

    @Override
    public boolean isOne(Enum<IRelationship.Cardinality> card) {
        return card == IRelationship.Cardinality.ZERO_ONE || card == IRelationship.Cardinality.ONE_ONE;
    }

    @Override
    public boolean isDummy() {
        return true;
    }

    private Enum<IRelationship.Cardinality> getCardinality(String min, String max) {
        if (min.equals("zero")) {
            if (max.equals("one")) {
                return IRelationship.Cardinality.ZERO_ONE;
            }
            if (max.equals("many")) {
                return IRelationship.Cardinality.ZERO_MANY;
            }
        }
        if (min.equals("one")) {
            if (max.equals("one")) {
                return IRelationship.Cardinality.ONE_ONE;
            }
            if (max.equals("many")) {
                return IRelationship.Cardinality.ONE_MANY;
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "getCardinality():  Unexpected cardinality.");
    }

    @Override
    public String getExpression() {
        return this.mExpression;
    }

    @Override
    public String getUniqueName() {
        return this.getV5UniqueName();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public IRelationship.JoinFilterType getJoinFilterType() {
        return IRelationship.JoinFilterType.FILTER_TYPE_NONE;
    }

    @Override
    public boolean isAccessible() {
        return false;
    }

    @Override
    public String getFJOAdvancedProperty() {
        return null;
    }
}

