/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.mdquery.parser;

import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ActionCoordinateTypeEnum;
import com.cognos.xqe.metadata.ActionTypeEnum;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;

class ConstraintsLibrary {
    private static final String SPACE_STRING = " ";
    private static final String EMPTY_STRING = "";
    private static final String ENUM_SET_DELIM = "|";
    private static final String CONSTRAINT_DIMENSION_LINE = "dimensionLine";
    private static final String CONSTRAINT_COORDINATE = "coordinate";
    private static final String CONSTRAINT_COORDINATE_TYPE = "coordinateType";
    private static final Map<String, RestrictionType> LIB = new HashMap<String, RestrictionType>();

    ConstraintsLibrary() {
    }

    public static void addMetadataRestriction(MetadataRestriction restrictions, String name, String value) {
        RestrictionType type = ConstraintsLibrary.getRestrictionType(name);
        if (type != null) {
            Object obj = ConstraintsLibrary.createObject(restrictions, type, value);
            restrictions.add(type, obj);
        }
    }

    private static RestrictionType getRestrictionType(String name) {
        RestrictionType type = LIB.get(name);
        if (type == null) {
            try {
                type = RestrictionType.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new XQERuntimeException(e);
            }
        }
        return type;
    }

    private static Object createObject(MetadataRestriction restrictions, RestrictionType type, String value) {
        Serializable obj = null;
        StringTokenizer token = null;
        switch (type) {
            case LEVEL_NUMBER: 
            case FROM: 
            case SIZE: {
                obj = Integer.valueOf(value);
                break;
            }
            case TREEOP: {
                token = new StringTokenizer(value, ENUM_SET_DELIM);
                LinkedList<TreeOperatorEnum> treeOps = new LinkedList<TreeOperatorEnum>();
                while (token.hasMoreTokens()) {
                    TreeOperatorEnum op = TreeOperatorEnum.valueOf(token.nextToken());
                    treeOps.add(op);
                }
                obj = EnumSet.copyOf(treeOps);
                break;
            }
            case MEMBER_TYPE: {
                obj = MemberTypeEnum.valueOf(value.toUpperCase());
                break;
            }
            case ACTION_TYPE: {
                obj = ActionTypeEnum.valueOf(value.toUpperCase());
                break;
            }
            case COORDINATE_TYPE: {
                token = new StringTokenizer(value, ENUM_SET_DELIM);
                LinkedList<ActionCoordinateTypeEnum> coordinates = new LinkedList<ActionCoordinateTypeEnum>();
                while (token.hasMoreTokens()) {
                    ActionCoordinateTypeEnum op = ActionCoordinateTypeEnum.valueOf(token.nextToken().toUpperCase());
                    coordinates.add(op);
                }
                EnumSet set = (EnumSet)restrictions.getValueOf(type);
                if (set == null) {
                    obj = EnumSet.copyOf(coordinates);
                    break;
                }
                set.addAll(coordinates);
                obj = set;
                break;
            }
            case ONLY_STRUCTURES: {
                String boolStr = value.toString();
                if (boolStr.equals(EMPTY_STRING) || boolStr.equals(SPACE_STRING)) {
                    obj = false;
                    break;
                }
                obj = true;
                break;
            }
            case PPDS_CODES: {
                ArrayList<String> ppdsCodes = (ArrayList<String>)restrictions.getValueOf(type);
                if (ppdsCodes == null) {
                    ppdsCodes = new ArrayList<String>();
                }
                ppdsCodes.add(value);
                obj = ppdsCodes;
                break;
            }
            default: {
                obj = value;
            }
        }
        return obj;
    }

    static {
        LIB.put("Catalog_Name", RestrictionType.CATALOG);
        LIB.put("Cube_Name", RestrictionType.CUBE);
        LIB.put("Tree_Operator", RestrictionType.TREEOP);
        LIB.put(CONSTRAINT_COORDINATE_TYPE, RestrictionType.COORDINATE_TYPE);
        LIB.put(CONSTRAINT_COORDINATE, RestrictionType.COORDINATE);
        LIB.put(CONSTRAINT_DIMENSION_LINE, RestrictionType.DIMENSION_UNIQUE_NAME);
        LIB.put("PPDS_CODE", RestrictionType.PPDS_CODES);
        LIB.put("Effective_Date", RestrictionType.KEY_DATE);
    }
}

