/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider;

import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Cube;
import com.cognos.xqe.metadata.provider.Metadata;
import java.util.ArrayList;
import java.util.List;

public class Catalog
extends Metadata
implements ICatalog {
    private final List<ICube> cubes = new ArrayList<ICube>();

    public void copyFrom(Catalog from) {
        super.copyFrom(from);
        this.cubes.clear();
        this.cubes.addAll(from.cubes);
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.CATALOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCube(Cube cube) {
        cube.setCatalog(this);
        List<ICube> list = this.cubes;
        synchronized (list) {
            this.cubes.add(cube);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICube[] getCubes() {
        List<ICube> list = this.cubes;
        synchronized (list) {
            return this.cubes.toArray(new ICube[this.cubes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICube getCube(String name) {
        List<ICube> list = this.cubes;
        synchronized (list) {
            for (ICube cube : this.cubes) {
                if (!cube.getName().equals(name)) continue;
                return cube;
            }
        }
        return null;
    }
}

