/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider;

import com.cognos.xqe.data.types.HierarchyType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Level;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Hierarchy
extends Metadata
implements IHierarchy {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(Hierarchy.class);
    public static final String ROOT_MUN = "rootMUN";
    public static final String VALID_TO = "Valid_To";
    public static final String VALID_FROM = "Valid_From";
    public static final String DEFAULT_MEMBER_EXTERNAL_NAME = "defaultMemberExternalName";
    static final long serialVersionUID = 7647274105530911872L;
    protected IDimension dimension = null;
    protected boolean initializedParentChild = false;
    private List<ILevel> levels = new ArrayList<ILevel>();
    protected Map<String, ILevel> levelUniqueNameMap = new HashMap<String, ILevel>();
    protected IMember defaultMember = null;
    protected IMember highestLevelRollup = null;
    protected String dimensionUniqueName;
    protected String defaultMemberName;
    protected int cardinality = 0;
    protected boolean balanced = true;
    protected boolean ragged = false;
    protected boolean multiRoot = false;
    protected boolean parentChild = false;
    protected List<String> relatedHierarchyNames = new ArrayList<String>();
    protected IMember rootMember;
    protected boolean autoGenerated = false;
    private ReadWriteLock levelsLock = new ReentrantReadWriteLock(true);

    public Hierarchy(String objectName) {
        super(objectName);
    }

    public Hierarchy() {
    }

    @Override
    public List<ILevel> getLevels() {
        this.initialiseChildren();
        this.levelsLock.readLock().lock();
        try {
            ArrayList<ILevel> arrayList = new ArrayList<ILevel>(this.levels);
            return arrayList;
        }
        finally {
            this.levelsLock.readLock().unlock();
        }
    }

    @Override
    public ILevel getLevel(String uniqueName) {
        this.initialiseChildren();
        this.levelsLock.readLock().lock();
        try {
            ILevel iLevel = this.levelUniqueNameMap.get(uniqueName);
            return iLevel;
        }
        finally {
            this.levelsLock.readLock().unlock();
        }
    }

    @Override
    public synchronized IDimension getDimension() {
        if (this.dimension == null) {
            if (null == this.getConnection()) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "Hierarchy.getDimension requires connection");
            }
            IMetadata mdObj = this.getConnection().getParentObject(this);
            while (mdObj != null && !(mdObj instanceof Dimension)) {
                mdObj = this.getConnection().getParentObject(mdObj);
            }
            if (mdObj instanceof Dimension) {
                this.dimension = (Dimension)mdObj;
            } else {
                throw new RuntimeException("Could not locate dimension of hierarchy " + this.getName());
            }
        }
        return this.dimension;
    }

    public synchronized void setDimension(IDimension refDimension) {
        this.dimension = refDimension;
    }

    public void addLevel(ILevel level) {
        this.levelsLock.writeLock().lock();
        try {
            ILevel aLevel = this.levelUniqueNameMap.get(level.getUniqueName());
            if (aLevel != null) {
                return;
            }
            this.levelUniqueNameMap.put(level.getUniqueName(), level);
            this.levels.add(level);
            if (level instanceof Level) {
                ((Level)level).setHierarchy(this);
            }
        }
        finally {
            this.levelsLock.writeLock().unlock();
        }
    }

    public Level addLevel(String name) {
        ILevel level = this.getLevel(name);
        if (level != null) {
            return (Level)level;
        }
        Level newlevel = new Level(name);
        String lun = UniqueNameGenerator.createUniqueName(this.getName(), name);
        newlevel.setUniqueName(lun);
        newlevel.setV5UniqueName(lun);
        newlevel.setInitialised();
        this.addLevel(newlevel);
        return newlevel;
    }

    @Override
    public int getCardinality() {
        this.initialiseProperties();
        return this.cardinality;
    }

    public void setCardinality(int theCardinality) {
        this.cardinality = theCardinality;
    }

    @Override
    public synchronized IMember getDefaultMember() {
        if (this.defaultMember == null) {
            String defaultMun;
            this.initialiseProperties();
            String rootMun = null;
            if (this.getRootMember() != null) {
                rootMun = this.getRootMember().getUniqueName();
            }
            if ((defaultMun = (String)this.getProperty(DEFAULT_MEMBER_EXTERNAL_NAME)) == null && rootMun == null) {
                return null;
            }
            if (defaultMun != null) {
                defaultMun = UniqueNameGenerator.createMemberExternalName(this, defaultMun);
                if (rootMun == null || !defaultMun.equals(rootMun)) {
                    Member defaultMemberInstance = new Member(defaultMun);
                    defaultMemberInstance.setUniqueName(defaultMun);
                    defaultMemberInstance.setConnection(this.getConnection());
                    defaultMemberInstance.setInitialised();
                    this.setDefaultMember(defaultMemberInstance);
                }
            }
            if (this.defaultMember == null && rootMun != null) {
                String tmpRootCaption = this.getRootMember().getCaption();
                List<ILevel> levelList = this.getLevels();
                Level rootLevel = null;
                if (levelList.size() == 0) {
                    rootLevel = new Level();
                    rootLevel.setHierarchy(this);
                } else {
                    rootLevel = (Level)levelList.get(0);
                }
                Member aDefaultMember = new Member(tmpRootCaption);
                aDefaultMember.setUniqueName(rootMun);
                aDefaultMember.setLevel(rootLevel);
                aDefaultMember.setConnection(this.getConnection());
                aDefaultMember.setInitialised();
                this.setDefaultMember(aDefaultMember);
            }
        }
        return this.defaultMember;
    }

    public synchronized void setDefaultMember(IMember member) {
        this.defaultMember = member;
    }

    @Override
    public int getLevelCount() {
        this.initialiseChildren();
        this.initialiseProperties();
        this.levelsLock.readLock().lock();
        try {
            if (this.isParentChild() && this.levels.isEmpty()) {
                throw new RuntimeException("Level count requested on ParentChild hierarchy with none known levels. Operation not supported.");
            }
            int n = this.levels.size();
            return n;
        }
        finally {
            this.levelsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isRagged() {
        this.initialiseProperties();
        return this.ragged;
    }

    public void setRagged(boolean isRagged) {
        this.ragged = isRagged;
    }

    @Override
    public boolean isUnbalanced() {
        this.initialiseProperties();
        return !this.balanced;
    }

    public void setBalanced(boolean isBalanced) {
        this.balanced = isBalanced;
    }

    @Override
    public boolean isParentChild() {
        this.initialiseProperties();
        return this.parentChild;
    }

    public void setParentChild(boolean theParentChild) {
        this.parentChild = theParentChild;
    }

    @Override
    public boolean isMultiRoot() {
        this.initialiseProperties();
        return this.multiRoot;
    }

    public void setMultiRoot(boolean theMultiRoot) {
        this.multiRoot = theMultiRoot;
    }

    @Override
    public String createCalculatedMemberUniqueName(String suffix) {
        if (this.getDimension().getCube() instanceof CubeWrapper) {
            return UniqueNameGenerator.appendUniqueName(this.getDimension().getUniqueName(), suffix);
        }
        return UniqueNameGenerator.appendUniqueName(this.getUniqueName(), suffix);
    }

    @Override
    protected void initialiseProperties() {
        if (!this.initialisedProperties) {
            this.levelsLock.writeLock().lock();
            try {
                if (!this.initialisedProperties) {
                    Hierarchy result;
                    if (this.getConnection() != null && (result = (Hierarchy)this.getConnection().initialiseObjectProperties(this)) != this) {
                        this.name = result.getName();
                        this.copyFrom(result);
                    }
                    this.initialisedProperties = true;
                    this.initialised = this.initialisedChildren;
                }
            }
            finally {
                this.levelsLock.writeLock().unlock();
            }
        }
    }

    @Override
    protected void initialiseChildren() {
        this.levelsLock.writeLock().lock();
        try {
            if (!this.initialisedChildren) {
                Hierarchy result;
                if (this.getConnection() != null && (result = (Hierarchy)this.getConnection().initialiseObjectChildren(this)) != this) {
                    this.levels = result.levels;
                    this.defaultMember = result.defaultMember;
                    this.dimension = result.dimension;
                }
                this.initialisedChildren = true;
                this.initialised = this.initialisedProperties && this.initialisedChildren;
            }
        }
        finally {
            this.levelsLock.writeLock().unlock();
        }
    }

    @Override
    public IDataType getDataType() {
        return HierarchyType.HIERARCHYTYPE;
    }

    @Override
    public ILevel getLevel(int index) {
        if (index < 0) {
            return null;
        }
        this.initialiseChildren();
        this.levelsLock.writeLock().lock();
        try {
            if (this.levels.size() <= index) {
                this.addLevelsFromTo(this.levels.size(), index);
            }
            ILevel iLevel = this.levels.get(index);
            return iLevel;
        }
        finally {
            this.levelsLock.writeLock().unlock();
        }
    }

    private void addLevelsFromTo(int fromIndex, int toIndex) {
        String levelNameStub = this.name + " Level ";
        for (int i = fromIndex; i <= toIndex; ++i) {
            Level newLevel = new Level(levelNameStub + i);
            this.levels.add(newLevel);
            newLevel.setHierarchy(this);
            newLevel.setAutoGenerated(true);
            String autoLevelName = Level.createLevelUniqueName(this, i);
            newLevel.setUniqueName(autoLevelName);
            newLevel.setConnection(this.getConnection());
        }
    }

    @Override
    public int getLevelIndex(ILevel level) {
        int levelIndex = -1;
        if (this.getLevels() != null) {
            levelIndex = this.getLevels().indexOf(level);
        }
        return levelIndex;
    }

    public void setLevel(ILevel l) {
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.HIERARCHY;
    }

    @Override
    public IMember[] getMembers() {
        return null;
    }

    @Override
    public IMember getMember(String memberUniqueName) {
        return null;
    }

    @Override
    public synchronized List<String> getRelatedHierarchyNames(ILevel lowestLevel) {
        if (this.relatedHierarchyNames.isEmpty()) {
            List<ILevel> levelList = this.getLevels();
            for (int i = 0; i <= lowestLevel.getIndex(); ++i) {
                ILevel level = levelList.get(i);
                String baseAttrHierarchy = (String)level.getProperty("baseAttributeHierarchyRef");
                if (baseAttrHierarchy == null) continue;
                this.relatedHierarchyNames.add(baseAttrHierarchy);
            }
            IDimension thisDimension = this.getDimension();
            List<IHierarchy> hierarchies = thisDimension.getHierarchies();
            for (int i = 0; i < this.relatedHierarchyNames.size(); ++i) {
                String relatedHierarchyName = this.relatedHierarchyNames.get(i);
                for (int k = 0; k < hierarchies.size(); ++k) {
                    IHierarchy hierarchy = hierarchies.get(k);
                    if (hierarchy == this) continue;
                    levelList = hierarchy.getLevels();
                    boolean baseAttrHierFoundInHierarchy = false;
                    for (int j = levelList.size() - 1; j >= 0; --j) {
                        int listIndex;
                        ILevel level = levelList.get(j);
                        String baseAttrHierarchy = (String)level.getProperty("baseAttributeHierarchyRef");
                        if (baseAttrHierarchy == null || !baseAttrHierFoundInHierarchy && !relatedHierarchyName.equals(baseAttrHierarchy)) continue;
                        for (listIndex = 0; listIndex < this.relatedHierarchyNames.size() && !this.relatedHierarchyNames.get(listIndex).equals(baseAttrHierarchy); ++listIndex) {
                        }
                        if (listIndex == this.relatedHierarchyNames.size()) {
                            this.relatedHierarchyNames.add(baseAttrHierarchy);
                        }
                        baseAttrHierFoundInHierarchy = true;
                    }
                }
            }
        }
        return this.relatedHierarchyNames;
    }

    public void copyFrom(Hierarchy from) {
        super.copyFrom(from);
        this.defaultMember = from.defaultMember;
        this.dimension = from.dimension;
        this.levels = from.levels;
        this.cardinality = from.cardinality;
        this.balanced = from.balanced;
        this.defaultMemberName = from.defaultMemberName;
        this.dimensionUniqueName = from.dimensionUniqueName;
        this.highestLevelRollup = from.highestLevelRollup;
        this.multiRoot = from.multiRoot;
        this.parentChild = from.parentChild;
        this.ragged = from.ragged;
        this.rootMember = from.rootMember;
        this.autoGenerated = from.autoGenerated;
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            this.v5UniqueName = UniqueNameGenerator.createV5UniqueName(this);
        }
        return this.v5UniqueName;
    }

    @Override
    public IMember getRootMember() {
        return this.rootMember;
    }

    public void setRootMember(IMember theRootMember) {
        this.rootMember = theRootMember;
    }

    @Override
    public boolean isShell() {
        return false;
    }

    @Override
    public IMember getHighestLevelRollup() {
        this.initialiseProperties();
        return this.highestLevelRollup;
    }

    public void setHighestLevelRollup(IMember theHighestLevelRollup) {
        this.highestLevelRollup = theHighestLevelRollup;
    }

    @Override
    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean theAutoGenerated) {
        this.autoGenerated = theAutoGenerated;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    protected ReadWriteLock getLevelsLock() {
        return this.levelsLock;
    }

    @Override
    public String getUniqueName() {
        this.initialiseProperties();
        if (null == this.uniqueName) {
            this.uniqueName = UniqueNameGenerator.createEscapedUniqueName(this.dimension.getName(), this.getName());
        }
        return this.uniqueName;
    }

    @Override
    public IMember[] getMembers(InterpreterContext ic) {
        return null;
    }

    @Override
    public List<IMember> getCalculatedMembers() {
        return null;
    }

    @Override
    public String getValidFrom() {
        return null;
    }

    @Override
    public String getValidTo() {
        return null;
    }

    @Override
    public IMember getDefaultMemberFromProvider() {
        return null;
    }
}

