/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider;

import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.ModelNotFoundException;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.NoMetadataReuseContext;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.CollectXQELogs;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ArrayWrapper;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.datasets.FlintServerManager;
import com.cognos.xqe.util.datasets.IFlintServerManager;
import com.cognos.xqemoser.MoserDataSource;
import com.cognos.xqemoser.MoserEmbeddedModuleWrapper;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModuleManager;
import com.cognos.xqemoser.MoserModuleUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dom4j.Element;

public final class MetadataService {
    public static final String MFW4J = "MFW4J";
    public static final String NATIVEODP = "NATIVEODP";
    public static final String MOSER = "MOSER";
    public static final String JSON = "JSON";
    public static final Integer FORCE_CM_TRUSTED = 0;
    public static final Integer FORCE_METADATA_REFRESH = 1;
    public static final Integer METADATA_REQUEST = 2;
    private static final boolean DEFAULT_CACHE_CLEANER_ENABLED = true;
    private static final long DEFAULT_CACHE_CLEANER_WAKEUP_INTERVAL = 10000L;
    private static final long DEFAULT_CONNECTION_LIFETIME = 180000L;
    private static final String CFG_NAME = "[@name]";
    private static final String CFG_CLASS_NAME = "[@className]";
    private static final String CFG_ENABLED = "[@enabled]";
    private static final String CFG_WAKEUP_INTERVAL = "[@wakeupInterval]";
    private static final String CFG_CONNECTION_LIFETIME = "[@connectionLifetime]";
    private static final String CACHE_CLEANER = "metadataService.cacheCleaner";
    private static final String LOG_GROUP = "MetadataService";
    private static final String LOGMSG_CONNECTION_CREATED = "Connection created ";
    private static final String LOGMSG_CONNECTION_REUSED = "Connection reused ";
    private static final String LOGMSG_CONNECTION_STALE = "Stale connection was not reused ";
    private static final String LOGMSG_CONNECTION_EXPIRED = "Connection expired ";
    private static final String LOGMSG_CONNECTION_RELEASE_FAILED = "Connection release failed: ";
    private static final String LOGMSG_CAUSED_BY = "; Caused by: ";
    private static final String LOGMSG_INITIALIZING_SERVICE = "Initializing service";
    private static final String LOGMSG_PROVIDER_LOAD_FAILED = "Failed to load provider: ";
    private static final String LOGMSG_STARTED_CLEANER = "Connection cache cleaner thread was started";
    private static final String LOGMSG_STOPPED_CLEANER = "Connection cache cleaner thread was stopped";
    private static final String LOGMSG_RELEASING_SERVICE = "Releasing service";
    private static final String ERRMSG_PROVIDER_NAME_MISSING = "providerName was null";
    private static final String ERRMSG_CONNECTION_STRING_MISSING = "connectionString was null";
    private static final String USE_IDENTITIES = "metadataService.useIdentities";
    private static final String MOSER_BASE_PATH = "metadataService.moserBasepath";
    private static final String DEFAULT_MOSER_BASEPATH = "/bi/v1/metadata/modules/";
    private static final String MOSER_BASE_MODULES_PATH = "metadataService.moserBaseModulesPath";
    private static final String DEFAULT_MOSER_BASE_MODULES_PATH = "/bi/v1/metadata/base_modules/";
    private static final String MOSER_CONFIG_BASE_PATH = "metadataService.moserConfigBasepath";
    private static final String DEFAULT_MOSER_CONFIG_BASEPATH = "/bi/v1/configuration/keys/";
    private static final String MOSER_PARQUETS_BASE_PATH = "metadataService.moserParquetsBasepath";
    private static final String DEFAULT_MOSER_PARQUETS_BASEPATH = "/bi/v1/metadata/parquets/";
    private static final String CONTENT_SERVICE_PATH = "metadataService.contentServiceBasepath";
    private static final String DEFAULT_CONTENT_SERVICE_BASEPATH = "/bi/v1/objects/";
    private static final String CONTENT_SERVICE_SEARCH_PATH = "metadataService.contentServiceSearchBasepath";
    private static final String DEFAULT_CONTENT_SERVICE_SEARCH_BASEPATH = "/bi/v1/search_path";
    private static final String MOSER_CONNECTION_CHECK_STALE_PERIOD = "metadataService.moserConnectionCheckStalePeriod";
    private static final String MOSER_CONNECTION_CHECK_STALE_LARGE_ETAGS = "metadataService.moserConnectionCheckStaleLargeEtags";
    private static final long DEFAULT_MOSER_CONNECTION_CHECK_STALE_PERIOD = 5000L;
    private static final int DEFAULT_MOSER_CONNECTION_CHECK_STALE_LARGE_ETAGS = 20;
    private static final String MOSER_GET_ALL_MODULES = "metadataService.moserGetAllModules";
    private static final String SERVICE_PREFIX_ENV = "SERVICE_PREFIX";
    private static SingletonHelper<MetadataService> singletonHelper = new SingletonHelper<MetadataService>(){

        @Override
        protected MetadataService newInstance() {
            return new MetadataService();
        }

        @Override
        protected void releaseImpl(MetadataService theInstance) {
            theInstance.release();
        }

        @Override
        protected void initializeImpl(MetadataService theInstance) {
        }
    };
    private final Map<String, Class<?>> providers = new HashMap();
    private final ConcurrentHashMap<ArrayWrapper<Object>, ConnectionEntry> connectionCache = new ConcurrentHashMap();
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
    private boolean cacheCleanerEnabled = false;
    private long cacheCleanerWakeupInterval = 10000L;
    private long connectionLifetime = 180000L;
    private Thread cacheCleanerThread = null;
    private final ReentrantLock cacheCleanerThreadLock = new ReentrantLock();
    private final Condition cacheCleanerThreadCondition = this.cacheCleanerThreadLock.newCondition();
    private volatile boolean cacheCleanerRunning = false;
    private XQELogger logger = null;
    private final AtomicLong numConnectionsCreated = new AtomicLong(0L);
    private final AtomicLong numConnectionsReused = new AtomicLong(0L);
    private final AtomicLong numConnectionsExpired = new AtomicLong(0L);
    private final AtomicLong numConnectionsInvalidated = new AtomicLong(0L);
    private boolean useIdentities = false;
    private String moserBasePath;
    private String moserBaseModulePath;
    private String csvToParquetBasePath;
    private String dsdriverBasePath;
    private String moserParquetsBasePath;
    private String moserConfigBasePath;
    private String contentServiceBasePath;
    private String contentServiceSearchBasePath;
    private long moserConnectionCheckStalePeriod = -1L;
    private int moserConnectionCheckStaleLargeEtags = -1;
    private boolean bMoserGetAllModules = true;

    private MetadataService() {
        this.initialize();
    }

    public static MetadataService getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    protected void initialize() {
        if (!XQEService.isInitialized()) {
            throw new XQERuntimeException(XQEMessageKeys.INI_XQEServiceWasNotInitialized);
        }
        this.getLogger().log(LOGMSG_INITIALIZING_SERVICE);
        this.loadProviders();
        if (this.cacheCleanerEnabled) {
            this.startCacheCleaner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        XQELogger traceLogger = this.getLogger();
        traceLogger.log(LOGMSG_RELEASING_SERVICE);
        this.stopCacheCleaner();
        this.cacheLock.writeLock().lock();
        try {
            for (ConnectionEntry entry : this.connectionCache.values()) {
                try {
                    MetadataConnection mdConnection = entry.getConnection();
                    if (null == mdConnection) continue;
                    mdConnection.release();
                }
                catch (Throwable ex) {
                    if (!traceLogger.isOn(LogLevel.WARN)) continue;
                    traceLogger.log(LogLevel.WARN, LOGMSG_CONNECTION_RELEASE_FAILED + entry.getKey() + LOGMSG_CAUSED_BY, ex);
                }
            }
            this.connectionCache.clear();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        if (traceLogger.isOn()) {
            StringBuilder buf = new StringBuilder();
            buf.append("[MetadataService Stats]");
            buf.append("\n* Connections created: ").append(this.numConnectionsCreated.longValue());
            buf.append("\n* Connections reused: ").append(this.numConnectionsReused.longValue());
            buf.append("\n* Connections expired: ").append(this.numConnectionsExpired.longValue());
            buf.append("\n* Connections invalidated: ").append(this.numConnectionsInvalidated.longValue());
            traceLogger.log(buf.toString());
        }
    }

    public long getNumberOfConnectionsCreated() {
        return this.numConnectionsCreated.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateEntriesForJUNITPackage(String packageName) {
        XQELogger traceLogger = this.getLogger();
        traceLogger.log(LOGMSG_RELEASING_SERVICE);
        this.cacheLock.writeLock().lock();
        try {
            Set<Map.Entry<ArrayWrapper<Object>, ConnectionEntry>> cacheEntries = this.connectionCache.entrySet();
            Iterator<Map.Entry<ArrayWrapper<Object>, ConnectionEntry>> entryIt = cacheEntries.iterator();
            while (entryIt.hasNext()) {
                ConnectionEntry entry = entryIt.next().getValue();
                if (!entry.getKey().toString().contains(packageName)) continue;
                this.numConnectionsExpired.incrementAndGet();
                entryIt.remove();
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    public static boolean[] getConnectionOptions(boolean forceCMTrusted, boolean forceMetadataRefresh, boolean metadataRequest) {
        return new boolean[]{forceCMTrusted, forceMetadataRefresh, metadataRequest};
    }

    public static MFWRequestContext getRequestContext(IExecutionEnvironment execEnv, String contentLocale, String productLocale, String userPassport, boolean[] connectionOptions) {
        MetadataService.validateArguments("dummy1", "dummy2", execEnv);
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        if (null == productLocale) {
            productLocale = LocaleConverter.localeToStr(reqEnv.getProductLocale());
        }
        if (null == contentLocale) {
            contentLocale = LocaleConverter.localeToStr(reqEnv.getRunLocale());
        }
        if (null == userPassport && null != reqEnv.getCAMPassport()) {
            userPassport = reqEnv.getCAMPassport();
        }
        MFWRequestContext aContext = MFWRequestContext.create((String)productLocale, (String)contentLocale, (String)userPassport);
        boolean forceCMTrusted = connectionOptions[FORCE_CM_TRUSTED];
        boolean forceMetadataRefresh = connectionOptions[FORCE_METADATA_REFRESH];
        boolean metadataRequest = connectionOptions[METADATA_REQUEST];
        reqEnv.setUpMFWContextHeader(aContext);
        aContext.setForceCMTrusted(forceCMTrusted);
        aContext.setIgnoreMetadataUpdateRetainPeriod(forceMetadataRefresh);
        aContext.setMetadataRequest(metadataRequest);
        aContext.setXQEExecutionEnvironment((Object)execEnv);
        aContext.setAdvancedIDResolution(true);
        if (null != execEnv.getConnectionElement()) {
            Element connectionSpec = (Element)execEnv.getConnectionElement().clone();
            aContext.setConnectionSpec(connectionSpec);
        }
        return aContext;
    }

    public MetadataConnection getConnection(String providerName, String connectionString, IExecutionEnvironment execEnv, boolean reuseCachedConnection) {
        return this.getConnectionForObjects(providerName, connectionString, execEnv, reuseCachedConnection, null);
    }

    public MetadataConnection getConnectionForObjects(String providerName, String connectionString, IExecutionEnvironment execEnv, boolean reuseCachedConnection, Set<String> objNames) {
        boolean forceCMTrusted = false;
        boolean forceMetadataRefresh = false;
        boolean metadataRequest = false;
        boolean[] connectionOptions = MetadataService.getConnectionOptions(forceCMTrusted, forceMetadataRefresh, metadataRequest);
        return this.getConnectionForObjects(providerName, connectionString, execEnv, reuseCachedConnection, connectionOptions, objNames);
    }

    public MetadataConnection getConnectionForceCMTrusted(String providerName, String connectionString, IExecutionEnvironment execEnv, boolean reuseCachedConnection) {
        boolean forceCMTrusted = true;
        boolean forceMetadataRefresh = false;
        boolean metadataRequest = false;
        boolean[] connectionOptions = MetadataService.getConnectionOptions(forceCMTrusted, forceMetadataRefresh, metadataRequest);
        return this.getConnection(providerName, connectionString, execEnv, reuseCachedConnection, connectionOptions);
    }

    public MetadataConnection getConnection(String providerName, String connectionString, IExecutionEnvironment execEnv, boolean reuseCachedConnection, boolean[] connectionOptions) {
        return this.getConnectionForObjects(providerName, connectionString, execEnv, reuseCachedConnection, connectionOptions, null);
    }

    public MetadataConnection getConnectionForObjects(String providerName, String connectionString, IExecutionEnvironment execEnv, boolean reuseCachedConnection, boolean[] connectionOptions, Set<String> objNames) {
        MetadataService.validateArguments(providerName, connectionString, execEnv);
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        String contentLocale = LocaleConverter.localeToStr(reqEnv.getRunLocale());
        String productLocale = LocaleConverter.localeToStr(reqEnv.getProductLocale());
        String expressionLocale = LocaleConverter.localeToStr(reqEnv.getExpressionLocale());
        String userPassport = reqEnv.getCAMPassport();
        MFWRequestContext requestContext = MetadataService.getRequestContext(execEnv, contentLocale, productLocale, userPassport, connectionOptions);
        return this.getConnectionForObjects(providerName, connectionString, expressionLocale, execEnv, reuseCachedConnection, requestContext, objNames);
    }

    public MetadataConnection getConnection(String providerName, String connectionString, String expressionLocale, IExecutionEnvironment execEnv, boolean reuseCachedConnection, MFWRequestContext requestContext) {
        return this.getConnectionForObjects(providerName, connectionString, expressionLocale, execEnv, reuseCachedConnection, requestContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataConnection getConnectionForObjects(String providerName, String connectionString, String expressionLocale, IExecutionEnvironment execEnv, boolean reuseCachedConnection, MFWRequestContext requestContext, Set<String> objNames) {
        MetadataService.validateArguments(providerName, connectionString, execEnv);
        XQELogger traceLogger = this.getLogger();
        Class<?> providerClass = this.providers.get(providerName);
        if (null == providerClass) {
            throw new XQERuntimeException(XQEMessageKeys.MD_UnknownMetadataProvider, providerName);
        }
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        if (null == reqEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_RequestEnvironmentMissing_INTERNAL);
        }
        boolean forceCMTrusted = requestContext.getForceCMTrusted();
        boolean forceMetadataRefresh = requestContext.getIgnoreUpdateRetainPeriod();
        if (null == expressionLocale) {
            expressionLocale = LocaleConverter.localeToStr(reqEnv.getExpressionLocale());
        }
        String contentLocale = requestContext.getContentLocale();
        String productLocale = requestContext.getProductLocale();
        String userPassport = requestContext.getUserPassport();
        boolean bSrcOfEmbeddedModule = MoserEmbeddedModuleWrapper.isSourceModule(objNames);
        boolean masterReuse = (NoMetadataReuseContext.canReuse() || bSrcOfEmbeddedModule) && reuseCachedConnection;
        boolean bMoser = MOSER.equals(providerName);
        boolean bIgnoreLocale = masterReuse && bMoser && bSrcOfEmbeddedModule;
        ArrayWrapper<Object> key = new ArrayWrapper<Object>(providerName, bIgnoreLocale ? null : contentLocale, bIgnoreLocale ? null : productLocale, bIgnoreLocale ? null : expressionLocale, this.getPassportOrIdentitiesForKey(masterReuse, userPassport, forceCMTrusted, reqEnv), execEnv.getConnectionSearchPath(), execEnv.getSignOnSearchPath(), connectionString);
        if (masterReuse && bMoser) {
            return this.getThreadSafeConnection(key, providerClass, connectionString, expressionLocale, execEnv, requestContext, objNames);
        }
        ConnectionEntry entry = null;
        MetadataConnection result = null;
        if (masterReuse && !forceCMTrusted && !CollectXQELogs.isLoggingEnabled(reqEnv)) {
            this.cacheLock.readLock().lock();
            try {
                entry = this.connectionCache.get(key);
                if (null != entry) {
                    result = entry.getConnection();
                }
            }
            finally {
                this.cacheLock.readLock().unlock();
            }
            if (result != null && result.isConnected()) {
                if (result.isStale(forceMetadataRefresh, requestContext.getMetadataRequest())) {
                    if (traceLogger.isOn()) {
                        traceLogger.log(LOGMSG_CONNECTION_STALE + key);
                    }
                    entry.removeFromCache();
                } else {
                    result.refreshMetadata();
                    if (traceLogger.isOn()) {
                        traceLogger.log(LOGMSG_CONNECTION_REUSED + key);
                    }
                    this.numConnectionsReused.incrementAndGet();
                    result.transferNags(execEnv);
                    return result;
                }
            }
        }
        try {
            result = (MetadataConnection)providerClass.newInstance();
        }
        catch (ModelNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            traceLogger.log(LogLevel.ERROR, "Failed to create provider instance: ", (Throwable)e);
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
        try {
            result.connect(connectionString, expressionLocale, execEnv, requestContext);
        }
        catch (RuntimeException e) {
            result.release();
            throw e;
        }
        if (!masterReuse && MOSER.equals(providerName)) {
            return result;
        }
        this.cacheLock.writeLock().lock();
        try {
            if (masterReuse && !forceCMTrusted && !CollectXQELogs.isLoggingEnabled(reqEnv)) {
                entry = this.connectionCache.get(key);
                MetadataConnection oldConnection = null;
                if (null != entry) {
                    oldConnection = entry.getConnection();
                }
                if (oldConnection != null && oldConnection.isConnected()) {
                    if (traceLogger.isOn()) {
                        traceLogger.log(LOGMSG_CONNECTION_REUSED + key);
                    }
                    this.numConnectionsReused.incrementAndGet();
                    result.release();
                    oldConnection.transferNags(execEnv);
                    MetadataConnection metadataConnection = oldConnection;
                    return metadataConnection;
                }
            }
            if (masterReuse) {
                entry = new ConnectionEntry(key, result);
                this.connectionCache.put(key, entry);
            }
            if (traceLogger.isOn()) {
                traceLogger.log(LOGMSG_CONNECTION_CREATED + key);
            }
            this.numConnectionsCreated.incrementAndGet();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        result.transferNags(execEnv);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetadataConnection getThreadSafeConnection(ArrayWrapper<Object> key, Class<?> providerClass, String connectionString, String expressionLocale, IExecutionEnvironment execEnv, MFWRequestContext requestContext, Set<String> objNames) {
        MetadataConnection mc;
        ConnectionEntry entry = null;
        this.cacheLock.readLock().lock();
        try {
            entry = this.connectionCache.get(key);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        boolean forceMetadataRefresh = requestContext.getIgnoreUpdateRetainPeriod();
        if (entry != null && (mc = entry.getConnection()) != null) {
            boolean stale = false;
            stale = mc instanceof MoserMetadataConnection ? ((MoserMetadataConnection)mc).isStaleForObject(objNames) : mc.isStale(forceMetadataRefresh, requestContext.getMetadataRequest());
            if (stale) {
                entry.removeFromCache();
            } else if (!execEnv.getIsMCStillValidForFlint() && !this.isMCStillValidForFlint(mc, execEnv)) {
                entry.removeFromCache();
            } else {
                mc.connect(connectionString, expressionLocale, execEnv, requestContext);
                mc.transferNags(execEnv);
                return mc;
            }
        }
        this.cacheLock.writeLock().lock();
        try {
            entry = new ConnectionEntry(key, (MetadataConnection)providerClass.newInstance());
            ConnectionEntry other = this.connectionCache.putIfAbsent(key, entry);
            if (other != null) {
                entry = other;
            }
        }
        catch (ModelNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        mc = entry.getConnection();
        mc.connect(connectionString, expressionLocale, execEnv, requestContext);
        if (mc instanceof MoserMetadataConnection && ((MoserMetadataConnection)mc).getLifeTime() >= 0L) {
            entry.lifeTime = ((MoserMetadataConnection)mc).getLifeTime();
        }
        mc.transferNags(execEnv);
        return mc;
    }

    public boolean isMCStillValidForFlint(MetadataConnection metaConnection, IExecutionEnvironment execEnv) {
        execEnv.setIsMCStillValidForFlint(true);
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (metaConnection instanceof MoserMetadataConnection && config.getBooleanProperty("queryExecution.flintServer.lazyConversion[@enabled]", false)) {
            IFlintServerManager ftServerMgr;
            boolean isFlintRunning = false;
            if (null != MoserModuleManager.getDatasetManager() && null != MoserModuleManager.getDatasetManager().getFlintServerManagerInstance() && FlintServerManager.FlintServerState.RUNNING == (ftServerMgr = MoserModuleManager.getDatasetManager().getFlintServerManagerInstance()).getFlintServerState()) {
                isFlintRunning = true;
            }
            for (IModelDataSource modelDS : metaConnection.getModelDataSources()) {
                String interfaceName = modelDS.getInterface();
                if ("FLINT".equals(interfaceName) && !isFlintRunning || "PARQUET".equals(interfaceName) && isFlintRunning) {
                    execEnv.setIsMCStillValidForFlint(false);
                    return false;
                }
                if (!"FLINT".equals(interfaceName) || !isFlintRunning) continue;
                try {
                    MoserModuleUtil.touchFlintDataset((MoserDataSource)modelDS, execEnv);
                }
                catch (Exception e) {
                    this.getLogger().log(LogLevel.WARN, String.format("Cannot reuse cached plan for metadata connection '%s' due to: %s.", metaConnection.toString(), e.getLocalizedMessage()));
                    execEnv.setIsMCStillValidForFlint(false);
                    return false;
                }
            }
        }
        execEnv.setIsMCStillValidForFlint(false);
        return true;
    }

    public Object getPassportOrIdentitiesForKey(boolean reuseConnection, String userPassport, boolean forceCMTrusted, RequestEnvironment reqEnv) {
        Object passportOrIdentities = null;
        Object identities = null;
        if (reuseConnection && this.useIdentities && !forceCMTrusted) {
            identities = ContentManager.getIdentitiesList(reqEnv);
        }
        passportOrIdentities = identities != null ? identities : userPassport;
        return passportOrIdentities;
    }

    public static boolean hasROLAPDatasource(MetadataConnection mdConnection) {
        List<IModelDataSource> dataSources = mdConnection.getModelDataSources();
        if (dataSources == null) {
            return false;
        }
        for (IModelDataSource modelDS : dataSources) {
            if (!modelDS.isROLAP()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeMetadataConnection getNativeConnection(IDataSource dataSource, ExecutionEnvironment execEnv) {
        if (null == dataSource) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "MetadataService.getNativeConnection() requires dataSource.");
        }
        if (null == execEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        XQELogger traceLogger = this.getLogger();
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        if (null == reqEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_RequestEnvironmentMissing_INTERNAL);
        }
        String contentLocale = LocaleConverter.localeToStr(reqEnv.getRunLocale());
        String productLocale = LocaleConverter.localeToStr(reqEnv.getProductLocale());
        String expressionLocale = LocaleConverter.localeToStr(reqEnv.getExpressionLocale());
        String userPassport = reqEnv.getCAMPassport();
        ArrayWrapper<Object> key = new ArrayWrapper<Object>(NATIVEODP, contentLocale, productLocale, expressionLocale, userPassport, dataSource.getDataSourceConnection().getConnectionString(null));
        ConnectionEntry entry = null;
        NativeMetadataConnection result = null;
        boolean reuse = NoMetadataReuseContext.canReuse();
        if (reuse) {
            this.cacheLock.readLock().lock();
            try {
                entry = this.connectionCache.get(key);
                if (null != entry) {
                    result = (NativeMetadataConnection)entry.getConnection();
                }
            }
            finally {
                this.cacheLock.readLock().unlock();
            }
            if (result != null && result.isConnected()) {
                if (result.isStale(false, false)) {
                    if (traceLogger.isOn()) {
                        traceLogger.log(LOGMSG_CONNECTION_STALE + key);
                    }
                    entry.removeFromCache();
                } else {
                    if (traceLogger.isOn()) {
                        traceLogger.log(LOGMSG_CONNECTION_REUSED + key);
                    }
                    this.numConnectionsReused.incrementAndGet();
                    return result;
                }
            }
        }
        this.cacheLock.writeLock().lock();
        try {
            if (reuse) {
                entry = this.connectionCache.get(key);
                if (null != entry) {
                    result = (NativeMetadataConnection)entry.getConnection();
                }
                if (result != null && result.isConnected()) {
                    if (result.isStale(false, false)) {
                        if (traceLogger.isOn()) {
                            traceLogger.log(LOGMSG_CONNECTION_STALE + key);
                        }
                        entry.removeFromCache();
                    } else {
                        if (traceLogger.isOn()) {
                            traceLogger.log(LOGMSG_CONNECTION_REUSED + key);
                        }
                        this.numConnectionsReused.incrementAndGet();
                        NativeMetadataConnection nativeMetadataConnection = result;
                        return nativeMetadataConnection;
                    }
                }
            }
            result = new NativeMetadataConnection();
            MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(dataSource, execEnv, null);
            try {
                result.connect(mdQueryArgs);
            }
            catch (RuntimeException e) {
                result.release();
                throw e;
            }
            entry = new ConnectionEntry(key, result);
            this.connectionCache.put(key, entry);
            if (traceLogger.isOn()) {
                traceLogger.log(LOGMSG_CONNECTION_CREATED + key);
            }
            this.numConnectionsCreated.incrementAndGet();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        return result;
    }

    public void registerProvider(String type, Class<?> provider) {
        this.providers.put(type, provider);
    }

    private void loadProviders() {
        XQELogger traceLogger = this.getLogger();
        XQEConfiguration cfg = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        XQESubConfiguration providerCfg = cfg.getChildren("MetadataService.providers.provider");
        while (providerCfg.hasNext()) {
            providerCfg.next();
            String name = providerCfg.getString(CFG_NAME, null);
            String className = providerCfg.getString(CFG_CLASS_NAME, null);
            if (null == name) {
                throw new XQERuntimeException(XQEMessageKeys.MD_MetadataServiceConfigurationError, "name");
            }
            if (null == className) {
                throw new XQERuntimeException(XQEMessageKeys.MD_MetadataServiceConfigurationError, "className");
            }
            try {
                Class<?> providerClass = Class.forName(className);
                this.providers.put(name, providerClass);
            }
            catch (Exception ex) {
                if (traceLogger.isOn(LogLevel.ERROR)) {
                    traceLogger.log(LogLevel.ERROR, LOGMSG_PROVIDER_LOAD_FAILED, (Throwable)ex);
                }
                throw XQERuntimeException.wrap(ex);
            }
        }
        this.cacheCleanerEnabled = cfg.getBooleanProperty("metadataService.cacheCleaner[@enabled]", true);
        this.cacheCleanerWakeupInterval = cfg.getLongProperty("metadataService.cacheCleaner[@wakeupInterval]", 10000L);
        this.connectionLifetime = cfg.getLongProperty("metadataService.cacheCleaner[@connectionLifetime]", 180000L);
        this.useIdentities = cfg.getBooleanProperty(USE_IDENTITIES, false);
        if (System.getProperties().containsKey(SERVICE_PREFIX_ENV)) {
            this.moserBasePath = System.getProperty(SERVICE_PREFIX_ENV) + "v1/metadata";
            this.csvToParquetBasePath = System.getProperty(SERVICE_PREFIX_ENV) + "v1/csv2pq";
            this.dsdriverBasePath = "/neo-dsdriver/db_connection_info/";
        } else {
            this.moserBasePath = cfg.getStringProperty(MOSER_BASE_PATH, DEFAULT_MOSER_BASEPATH);
        }
        this.moserBaseModulePath = cfg.getStringProperty(MOSER_BASE_MODULES_PATH, DEFAULT_MOSER_BASE_MODULES_PATH);
        this.moserConfigBasePath = cfg.getStringProperty(MOSER_CONFIG_BASE_PATH, DEFAULT_MOSER_CONFIG_BASEPATH);
        this.moserParquetsBasePath = cfg.getStringProperty(MOSER_PARQUETS_BASE_PATH, DEFAULT_MOSER_PARQUETS_BASEPATH);
        this.contentServiceBasePath = cfg.getStringProperty(CONTENT_SERVICE_PATH, DEFAULT_CONTENT_SERVICE_BASEPATH);
        this.contentServiceSearchBasePath = cfg.getStringProperty(CONTENT_SERVICE_SEARCH_PATH, DEFAULT_CONTENT_SERVICE_SEARCH_BASEPATH);
        this.moserConnectionCheckStalePeriod = cfg.getLongProperty(MOSER_CONNECTION_CHECK_STALE_PERIOD, 5000L);
        this.moserConnectionCheckStaleLargeEtags = cfg.getIntProperty(MOSER_CONNECTION_CHECK_STALE_LARGE_ETAGS, 20);
        this.bMoserGetAllModules = cfg.getBooleanProperty(MOSER_GET_ALL_MODULES, true);
    }

    private XQELogger getLogger() {
        if (null == this.logger) {
            this.logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", LOG_GROUP, LogLevel.INFO);
        }
        return this.logger;
    }

    private void startCacheCleaner() {
        this.cacheCleanerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                MetadataService.this.cacheCleanerTask();
            }
        }, "MetadataService-CacheCleaner");
        this.cacheCleanerRunning = true;
        this.cacheCleanerThread.start();
    }

    private void stopCacheCleaner() {
        if (this.cacheCleanerRunning && null != this.cacheCleanerThread) {
            this.cacheCleanerRunning = false;
        }
    }

    private void cacheCleanerTask() {
        XQELogger traceLogger = this.getLogger();
        traceLogger.log(LOGMSG_STARTED_CLEANER);
        while (this.cacheCleanerRunning) {
            try {
                this.cacheCleanerThreadLock.lock();
                this.cacheCleanerThreadCondition.await(this.cacheCleanerWakeupInterval, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.cacheCleanerThreadLock.unlock();
            }
            if (!this.cacheCleanerRunning) break;
            if (this.connectionLifetime <= 0L || !this.thereAreExpiredEntries()) continue;
            this.removeExpiredEntries();
        }
        traceLogger.log(LOGMSG_STOPPED_CLEANER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean thereAreExpiredEntries() {
        this.cacheLock.readLock().lock();
        try {
            long currentTime = System.currentTimeMillis();
            Set<Map.Entry<ArrayWrapper<Object>, ConnectionEntry>> cacheEntries = this.connectionCache.entrySet();
            Iterator<Map.Entry<ArrayWrapper<Object>, ConnectionEntry>> entryIt = cacheEntries.iterator();
            while (entryIt.hasNext()) {
                ConnectionEntry connEntry = entryIt.next().getValue();
                long lifetime = this.connectionLifetime;
                if (connEntry.lifeTime >= 0L) {
                    lifetime = connEntry.lifeTime;
                }
                if (currentTime - connEntry.getLastAccessTime() < lifetime) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredEntries() {
        XQELogger traceLogger = this.getLogger();
        this.cacheLock.writeLock().lock();
        try {
            long currentTime = System.currentTimeMillis();
            Set<Map.Entry<ArrayWrapper<Object>, ConnectionEntry>> cacheEntries = this.connectionCache.entrySet();
            Iterator<Map.Entry<ArrayWrapper<Object>, ConnectionEntry>> entryIt = cacheEntries.iterator();
            while (entryIt.hasNext()) {
                ConnectionEntry connEntry = entryIt.next().getValue();
                long lifetime = this.connectionLifetime;
                if (connEntry.lifeTime >= 0L) {
                    lifetime = connEntry.lifeTime;
                }
                if (currentTime - connEntry.getLastAccessTime() < lifetime) continue;
                if (traceLogger.isOn()) {
                    traceLogger.log(LOGMSG_CONNECTION_EXPIRED + connEntry.getKey());
                }
                this.numConnectionsExpired.incrementAndGet();
                connEntry.deregisterMoserConnection();
                entryIt.remove();
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    private static void validateArguments(String providerName, String connectionString, IExecutionEnvironment execEnv) {
        if (null == providerName) {
            throw new NullPointerException(ERRMSG_CONNECTION_STRING_MISSING);
        }
        if (null == connectionString) {
            throw new NullPointerException(ERRMSG_PROVIDER_NAME_MISSING);
        }
        if (null == execEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        if (null == reqEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_RequestEnvironmentMissing_INTERNAL);
        }
    }

    public boolean getUseIdentities() {
        return this.useIdentities;
    }

    public void setUseIdentities(boolean flag) {
        this.useIdentities = flag;
    }

    public void setConnectionLifetime(long timeLimit) {
        this.connectionLifetime = timeLimit;
    }

    public void setCacheCleanerWakeupInterval(long interval) {
        this.cacheCleanerWakeupInterval = interval;
        if (this.cacheCleanerThread != null) {
            try {
                this.cacheCleanerThreadLock.lock();
                this.cacheCleanerThread.interrupt();
            }
            finally {
                this.cacheCleanerThreadLock.unlock();
            }
        }
    }

    public long getCacheCleanerWakeupInterval() {
        return this.cacheCleanerWakeupInterval;
    }

    public long getConnectionLifetime() {
        return this.connectionLifetime;
    }

    public int getNumberOfConnections() {
        try {
            this.cacheLock.readLock().lock();
            int n = this.connectionCache.size();
            return n;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public String getMoserBasePath() {
        return this.moserBasePath;
    }

    public String getMoserParquetsBasePath() {
        return this.moserParquetsBasePath;
    }

    public String getDsDriverBasePath() {
        return this.dsdriverBasePath;
    }

    public String getCSVToParquetBasePath() {
        return this.csvToParquetBasePath;
    }

    public long getMoserConnectionCheckStalePeriod() {
        return this.moserConnectionCheckStalePeriod;
    }

    public int getMoserConnectionCheckStaleLargeEtages() {
        return this.moserConnectionCheckStaleLargeEtags;
    }

    public boolean getMoserAllModules() {
        return this.bMoserGetAllModules;
    }

    public String getMoserConfigBasePath() {
        return this.moserConfigBasePath;
    }

    public static String getProviderTypeFromModelPath(String modelType, String modelPath) {
        if ("module".equals(modelType) || modelPath.startsWith(MetadataService.getInstance().getMoserBasePath()) || modelPath.contains("/module[@name=") || modelPath.endsWith("_sessionTemp")) {
            return MOSER;
        }
        return MFW4J;
    }

    public String getContentServiceBasePath() {
        return this.contentServiceBasePath;
    }

    public String getContentServiceSearchBasePath() {
        return this.contentServiceSearchBasePath;
    }

    public String getMoserBaseModulesPath() {
        return this.moserBaseModulePath;
    }

    private final class ConnectionEntry {
        private final ArrayWrapper<Object> key;
        private volatile MetadataConnection connection = null;
        private volatile long creationTime = 0L;
        private volatile long lastAccessTime = 0L;
        private volatile long lifeTime = -1L;

        ConnectionEntry(ArrayWrapper<Object> theKey, MetadataConnection theConnection) {
            this.key = theKey;
            this.connection = theConnection;
            this.lastAccessTime = this.creationTime = System.currentTimeMillis();
        }

        public void deregisterMoserConnection() {
            if (this.connection != null && this.connection instanceof MoserMetadataConnection) {
                ((MoserMetadataConnection)this.connection).deregister();
            }
        }

        public ArrayWrapper<Object> getKey() {
            return this.key;
        }

        public MetadataConnection getConnection() {
            this.updateLastAccessTime();
            return this.connection;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public void updateLastAccessTime() {
            this.lastAccessTime = System.currentTimeMillis();
        }

        public void removeFromCache() {
            MetadataService.this.cacheLock.writeLock().lock();
            try {
                MetadataService.this.connectionCache.remove(this.getKey());
                this.deregisterMoserConnection();
            }
            finally {
                MetadataService.this.cacheLock.writeLock().unlock();
            }
        }
    }
}

